/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *    utils.h
 *
 *    various utility functions
 */

#ifndef _UTILS_H_
#define _UTILS_H_

class Electron;

extern char const *progname;

char *sstrdup(char const *str);
char *sstrncpy(char *into, char const *from, int maxlen);
char *sstrncat(char *into, char const *from, int maxlen);
int ssprintf(char *into, int maxsize, char *fmt, ...);




// where to look for datafiles maps etc etc etc (typically /usr/local/share/electron)
char const *get_electron_home();

// where to put configfiles (typically ~/.electron)
char const *get_config_dir();


void warning(char const *fmt, ...);
void fatal(char const *fmt, ...);
void common_assert(char const *file, int line);  // use ASSERT
extern Electron *get_electron_from_type(int type, int id);

// is this used at all? does it work? those are the mysteries of life...
//extern void delete_electron_recursive(Electron *e);

#ifndef ASSERT
    #ifdef DEBUGMODE
        #define ASSERT(condition) { if (!(condition)) common_assert(__FILE__, __LINE__); }
        #define TRACE warning
    #else
        #define ASSERT(condition)
        #define TRACE 1 ? (void) 0 : warning
    #endif
#endif

#endif
