/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *    utils.cc
 *
 *    various utility functions
 */
 
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "utils.h"
#include "list.h"
#include "electron.h"


char const *progname = "--";

char *sstrdup(char const *str)
{
    char *tmp = strdup(str);
    if (!tmp)
        fatal("sstrdup: out of memory");

    return tmp;
}

/* copies at most maxlen -1 chars and makes it always NULL terminated */
char *sstrncpy(char *to, char const *from, int maxlen)
{
     char *org = to;

//     warning("sstrcpy to >%s< from >%s<, maxlen %d",to, from, maxlen);

     int  i = 0;
     while(*from && i < maxlen - 1)
     {
         *to = *from;
//         warning("sstrcpy to >%s< >%s< from >%s<, i %d",org,to, from, i);
         to++;
         from++;
         i++;
     }

     *to = '\0';
//     warning("sstrcpy done to >%s< from >%s<, i %d",org, from, i);
     
     return org;
}

char *sstrncat(char *into, char const *from, int maxlen)
{
   return sstrncpy(into + strlen(into), from, maxlen - strlen(into));
}



// deletes an electron *and* all electrons in it's inventory
// this does not remove the thing form storage/lattice so that should
// be done before this
extern void delete_electron_recursive(Electron *e)
{
   List *inv;

   Electron *child;

   inv = e->inv();

   if (inv)
   {
      inv->reset();

      while((child = (Electron *)inv->get()))
      {
         delete_electron_recursive(child);
         inv->next();
      }
      
   }

   delete_object(e);

}


// where to look for datafiles maps etc etc etc (typically /usr/local/share/electron)
char const *get_electron_home()
{
    char const *ehome = getenv("ELECTRON_HOME");

    if (!ehome)
        ehome = ELECTRON_HOME;


    return ehome;
}

// where to put configfiles (typically ~/.electron)
char const *get_config_dir()
{
    static char buffer[1024];
    char *home = getenv("HOME");

    // cannot get home, use current dir
    if (!home)
        home = ".";

    ssprintf(buffer, 1024, "%s/.electron", home);


    return buffer;
}
    

int ssprintf(char *into, int maxsize, char *fmt, ...)
{
    va_list args;
    va_start( args, fmt );

    #ifdef vsnprintf
    int ret = vsnprintf( into , maxsize, fmt, args );
    #else
    int ret = vsprintf( into , fmt, args );
    #endif
    va_end(args);

    return ret;
}




