/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        trigger.h
 *
 *        class interface to add trigger functionality to Electron
 */

#ifndef _TRIGGER_H_
#define _TRIGGER_H_

/*
 *        Trigger is NOT derived from Object on purpose: we want to
 *        use multiple inheritance to derive Electron from Trigger,
 *        and to prevent scary double derivations we do not want Electron
 *        to be derived from Object twice.
 *
 *        Trigger should probably not have any data either, only function
 *        interfaces.
 */

class Electron;
class Atom;

class Trigger
{
public:
    virtual int trigger_enter_atom(Electron *who);
    virtual int trigger_leave_atom(Electron *who);
    virtual int trigger_enter_electron(Electron *who, Electron *what);
    virtual int trigger_leave_electron(Electron *who, Electron *what);
    virtual int trigger_explode(Electron *who);
    virtual int trigger_die(Electron *who);
};

extern void trigger_leave(Electron *who, Atom *from_where);
extern void trigger_enter(Electron *who, Atom *where_to);
extern void trigger_leave_electron(Electron *who, Electron *where_from);
extern void trigger_enter_electron(Electron *who, Electron *where_to);

#endif
