/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        trigger.cc
 *
 *        (empty) function bodies of the base trigger functions
 */

#include "trigger.h"
#include "list.h"
#include "atom.h"
#include "electron.h"

int Trigger::trigger_enter_atom(Electron *who)
{
    return 0;
}

int Trigger::trigger_leave_atom(Electron *who)
{
    return 0;
}

int Trigger::trigger_enter_electron(Electron *who, Electron *what)
{
    return 0;
}

int Trigger::trigger_leave_electron(Electron *who, Electron *what)
{
    return 0;
}

int Trigger::trigger_explode(Electron *who)
{
    return 0;
}

int Trigger::trigger_die(Electron *who)
{
    return 0;
}

// utility functions to call triggers
void trigger_leave(Electron *who, Atom *from_where)
{
    List *i;
    List scratch_list;
    Electron *top = from_where->top_level_object;
    Electron *e;
    
    ASSERT(top);

    i = top->inv();
    if (!i)
	return;

    i->clearcopy(&scratch_list);

    for (scratch_list.reset();
	 (e = (Electron *)scratch_list.get());
	 scratch_list.next())
    {
	// don't trigger yourself
	if (who == e)
	    continue;
	
	// it's possible that elements die during traversal of the list
	// therefore check if they still live before processing them.
	// example: mine explodes and kills not only itsself but also
	// a player.
	if (e->dead)
	    continue;

	e->trigger_leave_atom(who);
    }
}

void trigger_enter(Electron *who, Atom *where_to)
{
    List *i;
    List scratch_list;
    Electron *top = where_to->top_level_object;
    Electron *e;
    
    ASSERT(top);

    i = top->inv();
    if (!i)
	return;

    i->clearcopy(&scratch_list);

    for (scratch_list.reset();
	 (e = (Electron *)scratch_list.get());
	 scratch_list.next())
    {
	// don't trigger yourself
	if (who == e)
	    continue;
	
	// it's possible that elements die during traversal of the list
	// therefore check if they still live before processing them.
	// example: mine explodes and kills not only itsself but also
	// a player.
	if (e->dead)
	    continue;

	e->trigger_enter_atom(who);
    }
}

void trigger_enter_electron(Electron *who, Electron *where_to)
{
    List *i;
    List scratch_list;
    Electron *e;
    
    ASSERT(who);
    ASSERT(where_to);

    i = where_to->inv();
    if (i)
    {
	i->clearcopy(&scratch_list);
	
	for (scratch_list.reset();
	     (e = (Electron *)scratch_list.get());
	     scratch_list.next())
	{
	    // don't trigger yourself
	    if (who == e)
		continue;
	    
	    // it's possible that elements die during traversal of the list
	    // therefore check if they still live before processing them.
	    // example: mine explodes and kills not only itsself but also
	    // a player.
	    if (e->dead)
		continue;
	    
	    e->trigger_enter_electron(who, where_to);
	}
    }

    // trigger the new parent
    where_to->trigger_enter_electron(who, where_to);
}


void trigger_leave_electron(Electron *who, Electron *where_from)
{
    List *i;
    List scratch_list;
    Electron *e;
    
    ASSERT(who);
    ASSERT(where_from);

    i = where_from->inv();
    if (i)
    {
	i->clearcopy(&scratch_list);
	
	for (scratch_list.reset();
	     (e = (Electron *)scratch_list.get());
	     scratch_list.next())
	{
	    // don't trigger yourself
	    if (who == e)
		continue;
	    
	    // it's possible that elements die during traversal of the list
	    // therefore check if they still live before processing them.
	    // example: mine explodes and kills not only itsself but also
	    // a player.
	    if (e->dead)
		continue;
	    
	    e->trigger_leave_electron(who, where_from);
	}
    }

    // trigger the old parent
    where_from->trigger_enter_electron(who, where_from);
}
