
#ifndef _SEARCHROUT_H_
#define _SEARCHROUT_H_

// #define DEBUG_ROUTEPLANNER 1

#ifdef DEBUG_ROUTEPLANNER
 #include <allegro.h>
#endif

#include "object.h"
#include "atom.h"
#include "list.h"


class Routeplanner
 : public  Object
{
 public:
   Routeplanner();
   ~Routeplanner();
   void set();
   void clear();

   // asks a new route
   void init_search(Atom *from, Atom *to,
		    int (*cost)(Electron *what, Atom *a, Atom *b) = NULL);


   // does 1 iteration in the search, returns TRUE when the search is done
   int do_search(Electron *what);
   
   // returns last calculated route, or NULL if there is no
   // last calculated route, or the last route search did not find
   // a route, the asker should delete the list when finished with it
   List *last_route();

   #ifdef DEBUG_ROUTEPLANNER
      void draw_route(BITMAP *onto);
   #endif

   private:
    unsigned int longesttried;
    int iterations;
    int w,h; // lattice size this routeplanner is for

//    each int in the work array is used like this:
//  wa >>4 : distance
//  wa & 3 : direction
//  wa & (1<<2) : currently in the to_do list
    unsigned short **work_array;
    List *to_do;
    int busy;
    int found;
    Atom *target;
    Atom *startpoint;

    void new_work_array();
    void del_work_array();
    void check_work_array();
    void clear_work_array();

    int (* calc_cost)(Electron *what, Atom *a, Atom *b);


    int dist_estimate(Atom *from, Atom *to);

};

extern Routeplanner *new_routeplanner();

#endif
