/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        permissions.cc
 *
 *        permissions table and functions to use it
 */

#include <string.h>
#include "permissions.h"
#include "utils.h"

/*
 *
 * permissies zijn alleen voor schrijven, lezen mag altijd
 * s = system, o = owner, a = all, - = none
 * 1e char is 1e var, 2e char = 2e var etc.
 *
 * client negeert deze permissies (behalve misschien debug
 * op '-'(none) ).
 *
 */

/* intvars, stringvars, vectorvars */

char const ***permissions;

// create the permissions array dynamically from the translate_types array
void init_permissions()
{
    permissions = new char const **[ACTOR_LAST];
    
    for (int i = 0; i < ACTOR_LAST; i++)
    {
	permissions[translate_types[i].actor_type] = new char const *[3];

	for (int j = 0; j < 3; j++)
	{
	    permissions[translate_types[i].actor_type][j] =
		translate_types[i].permissions[j];
	}
    }
}

// delete the allocated 
void shutdown_permissions()
{
    if (permissions)
    {
	for (int i = 0; i < ACTOR_LAST; i++)
	{
	    delete [] permissions[i];
	}

	delete [] permissions;
	
	permissions = 0;
    }
}

int permission_granted(int actor_type, int var_type, int var_index,
		       int owner, int system_priv = 0)
{

    /* debug code */
    if (actor_type < 0 || actor_type >= ACTOR_LAST)
    {
	warning("permission_granted: invalid actor_type %d", actor_type);
	return 0;
    }

    if (var_type < 0 || var_type > 2)
    {
	warning("permission_granted: invalid var_type %d", var_type);
	return 0;
    }

    if (var_index < 0
	||
	var_index >= (int)strlen(permissions[actor_type][var_type]))
    {
	warning("permission granted: invalid var_index %d (for actor_type %d var_type %d( max index %d))", var_index, actor_type, var_type, (int)strlen(permissions[var_type][actor_type]) - 1);
	return 0;
    }

    /* end of debug code */

    warning("permission: [%d][%d][%d] : %c",
	    actor_type,
	    var_type,
	    var_index,
	    permissions[actor_type][var_type][var_index]);
    
    switch(permissions[actor_type][var_type][var_index])
    {
	case 's':
	    /* only allowed if we have system_priviliges */
	    return system_priv; 
	    break;
	case 'o':
	    /* allowed if we either have system_priviliges or we are
	       the owner */
	    return (owner || system_priv);
	    break;
	case 'a':
	    /* always allowed */
	    return 1;
	    break;
	case '-':
	    /* never allowed */
	    return 0;
	    break;
	default:
	    return 0;
	    break;
    }
}
    
