/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *   packt_in.cc
 *
 *   class implementation of Packet_info_vect
 */

#include <stdlib.h>
#include "packet.h"

Packet_info_vect::Packet_info_vect()
{
    set(0, 0, 0, 0, 0);
}


Packet_info_vect::Packet_info_vect(int _actor_type, int _actor_id,
				 int _var_id, int _x, int _y)
{
    set(_actor_type, _actor_id, _var_id, _x, _y);
}

void Packet_info_vect::set(int _actor_type, int _actor_id,
				 int _var_id, int _x, int _y)
{
    type = TYPE_INFO_VECT;
    freelist_index = COMMON_FREELIST_PACKET_INFO_VECT;
    
    actor_type = _actor_type;
    actor_id = _actor_id;
    var_id = _var_id;
    var_x = _x;
    var_y = _y;
}

void Packet_info_vect::set(Packet_info_vect const *other)
{
    set(other->actor_type,
	other->actor_id,
	other->var_id,
	other->var_x,
	other->var_y);
}

Packet_info_vect::Packet_info_vect(Plug *connection)
{
    set(connection);
}

void Packet_info_vect::set(Plug *connection)
{
    type = TYPE_INFO_VECT;
    freelist_index = COMMON_FREELIST_PACKET_INFO_VECT;
    
    read_from(connection);
}

Packet_info_vect::~Packet_info_vect()
{
    clear();
}

void Packet_info_vect::clear()
{
    // do nothing
}

// read_from KNOWS that data is available, because the first
// byte of the packet has already been read. therefore it may
// retry until it reads the rest of the packet.
int Packet_info_vect::read_from(Plug *connection)
{
    int result;

    while (!(result = connection->read(buffer, PACKET_INFO_VECT_SIZE)))
    {
	warning("Packet_info_vect::read_from : no data, retrying");	
	continue;
    }
    
    if (result < PACKET_INFO_VECT_SIZE)
    {
        err = -1;
        ssprintf(Packet::error, 1024,
		"Error reading vector info packet : read returns %d",
		result);
        return -1;
    }
    
    read_actor(buffer);  // reads 4 bytes from buffer
    var_id = buffer[6];
    var_x = int2_from_string(buffer + 7);
    var_y = int2_from_string(buffer + 9);

    return result;
}

int Packet_info_vect::write_to(Plug *connection)
{
    buffer[0] = TYPE_INFO_VECT;
    write_actor(buffer + 1);
    buffer[7] = char(var_id);
    int2_to_string(var_x, buffer + 8);
    int2_to_string(var_y, buffer + 10);

    return connection->write(buffer, PACKET_INFO_VECT_SIZE + 1);
}

int Packet_info_vect::write_to_bogus(Plug *connection, int quit)
{
    buffer[0] = TYPE_INFO_VECT;
    write_actor(buffer + 1);
    buffer[7] = char(var_id);
    int2_to_string(var_x, buffer + 8);
    int2_to_string(var_y, buffer + 10);

    int ret = connection->write(buffer, PACKET_INFO_VECT_SIZE/2 + 1);

    if (quit)
       abort();

    return ret;
}


int Packet_info_vect::write_to(Plug *connection, int _actor_type,
			      int _actor_id, int _var_id, int _var_x, int _var_y)
{
    buffer[0] = TYPE_INFO_VECT;
    int2_to_string(_actor_type, buffer + 1);
    int4_to_string(_actor_id, buffer + 3);
    buffer[7] = (char)_var_id;
    int2_to_string(_var_x, buffer + 8);
    int2_to_string(_var_y, buffer + 10);

    return connection->write(buffer, PACKET_INFO_VECT_SIZE + 1);
}

int Packet_info_vect::expect(Packet const *_p, int _actor_type, int _actor_id, int _var_id, int _x, int _y)
{
    Packet_info_vect const *p;
    
    if (!_p)
	return FALSE;
    if (_p->err)
    {
	warning("Packet_info_vect::expect : error : %s", Packet::error);
	return 0;
    }

   if (_p->get_type() != TYPE_INFO_VECT)
      return FALSE;

   p = (Packet_info_vect *)_p;

   if (_actor_type != NA && p->actor_type != _actor_type)
      return FALSE;

   if (_actor_id != NA && p->actor_id != _actor_id)
      return FALSE;

   if (_var_id != NA && p->var_id != _var_id)
      return FALSE;

   if (_x != NA && p->var_x != _x)
      return FALSE;

   if (_y != NA && p->var_y != _y)
      return FALSE;

   return TRUE;

}


char Packet_info_vect::buffer[PACKET_INFO_VECT_SIZE + 1];



Packet_info_vect *new_packet_info_vect()
{
    Packet_info_vect *tmp;

    tmp = (Packet_info_vect *)new_object(COMMON_FREELIST_PACKET_INFO_VECT);

    if (!tmp)
    {
	tmp = new Packet_info_vect;
    }
    else
    {
	tmp->set(0, 0, 0, 0, 0);
    }

    return tmp;
}

Packet_info_vect *new_packet_info_vect(Packet_info_vect const *other)
{
    Packet_info_vect *tmp;

    tmp = (Packet_info_vect *)new_object(COMMON_FREELIST_PACKET_INFO_VECT);

    if (!tmp)
    {
	tmp = new Packet_info_vect;
    }

    tmp->set(other);

    return tmp;
}

Packet_info_vect *new_packet_info_vect(int actor_type, int actor_id, int var_id, int x, int y)
{
    Packet_info_vect *tmp;

    tmp = (Packet_info_vect *)new_object(COMMON_FREELIST_PACKET_INFO_VECT);

    if (!tmp)
    {
	tmp = new Packet_info_vect(actor_type, actor_id, var_id, x, y);
    }
    else
    {
	tmp->set(actor_type, actor_id, var_id, x, y);
    }

    return tmp;
}

/* the same function with an Electron as first argument */
Packet_info_vect *new_packet_info_vect(int actor_type, int actor_id, int var_id, Vector v)
{
    return new_packet_info_vect(actor_type,
				actor_id,
				var_id,
				v.x,
				v.y);
}

Packet_info_vect *new_packet_info_vect(Electron *actor, int var_id, Vector v)
{
    return new_packet_info_vect(actor->actor_type,
				actor->actor_id,
				var_id,
				v.x,
				v.y);
}

Packet_info_vect *new_packet_info_vect(Electron *actor, int _var_id, int _x, int _y)
{
    return new_packet_info_vect(actor->actor_type,
				actor->actor_id,
				_var_id,
				_x,
				_y);
}

Packet_info_vect *new_packet_info_vect(Plug *connection)
{
    Packet_info_vect *tmp;

    tmp = (Packet_info_vect *)new_object(COMMON_FREELIST_PACKET_INFO_VECT);

    if (!tmp)
    {
	tmp = new Packet_info_vect(connection);
    }
    else
    {
	tmp->set(connection);
    }

    return tmp;
}

