/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 * packt_is.cc
 *
 * implementation of Packet_info_string class
 */

#include <string.h>
#include <stdlib.h>
#include "packet.h"
#include "utils.h"


Packet_info_string::Packet_info_string()
{
    set(0, 0, 0, NULL);
}


Packet_info_string::Packet_info_string(int _actor_type, int _actor_id, int _var_id, char const *_var_value)
{
    set(_actor_type, _actor_id, _var_id, _var_value);
}

Packet_info_string::Packet_info_string(Plug *connection)
{
    set(connection);
}

// call clear first!!!!
void Packet_info_string::set(int _actor_type, int _actor_id, int _var_id, char const *_var_value)
{
    type = TYPE_INFO_STRING;
    string_value = NULL;
    freelist_index = COMMON_FREELIST_PACKET_INFO_STRING;
    
    max_string_length = string_length = 0;
    actor_type = _actor_type;
    actor_id = _actor_id;
    var_id = _var_id;

    if (_var_value)
    {
	string_value = sstrdup(_var_value);
	max_string_length = string_length = strlen(string_value);
    }
}

void Packet_info_string::set(Packet_info_string const *other)
{
    set(other->actor_type,
	other->actor_id,
	other->var_id,
	other->string_value);
}

// call clear first!
void Packet_info_string::set(Plug *connection)
{
    type = TYPE_INFO_STRING;
    string_value = NULL;
    max_string_length = string_length = 0;
    freelist_index = COMMON_FREELIST_PACKET_INFO_STRING;

    string_value = NULL;
    type = TYPE_INFO_STRING;

    // read_from will set the err and error variables on failure (-1)
    if (read_from(connection) == -1)
    {
	warning("packet_info_string : read failed during construction");
    }
}

Packet_info_string::~Packet_info_string()
{
    clear();
}

void Packet_info_string::clear()
{
    if (string_value)
	delete string_value;
    string_value = 0;
}

// read_from KNOWS that data is available, because the first
// byte of the packet has already been read. therefore it may
// retry until it reads the rest of the packet.
int Packet_info_string::read_from(Plug *connection)
{
    int ret;
    int ret2;
    int ret3;
    
    while (!(ret = connection->read(buffer, PACKET_INFO_STRING_SIZE)))
    {
	warning("Packet_info_string::read_from : no data, retrying");	
	continue;
    }
    
    if (ret < PACKET_INFO_STRING_SIZE)
    {
        err = -1;
        ssprintf(Packet::error, 1024,
            "Error reading string info packet : read returns %d",
            ret);

        string_length = 0;
        
        return -1;
    }
    
    read_actor(buffer);
    var_id = buffer[6];
    string_length = int2_from_string(buffer+7);

    if (string_length > max_string_length)
    {
         delete [] string_value;
         string_value = new char[string_length + 1];
         max_string_length = string_length;
//    warning("string length read = %d ret = %d", string_length, ret);
    }
    ret2 = 0;
    while (ret2 != string_length)
    {
        ret3 = connection->read(string_value, string_length - ret2);
        if (ret3 >= 0)
            ret2 += ret3;
        else
        {
            err = -1;
            ssprintf(Packet::error, 1024, "Error reading string info packet");
	    string_value = NULL;
	    string_length = 0;
            return -1;
        }
    }

    string_value[string_length] = 0;

    return ret + ret2;
}

int Packet_info_string::write_to(Plug *connection)
{
    int ret = 0;
    int ret2 = 0;
    
    buffer[0] = TYPE_INFO_STRING;
    write_actor(buffer + 1);
    buffer[7] = var_id;
    int2_to_string(string_length, buffer + 8);

    ret = connection->write(buffer, PACKET_INFO_STRING_SIZE + 1);
    if (ret <0)
        return -1;

    ret2 = connection->write(string_value, string_length);
    if (ret2 <0)
       return -1;

    return ret + ret2;
}

int Packet_info_string::write_to_bogus(Plug *connection, int quit)
{
    int ret = 0;
    int ret2 = 0;
    
    buffer[0] = TYPE_INFO_STRING;
    write_actor(buffer + 1);
    buffer[7] = var_id;
    int2_to_string(string_length, buffer + 8);

    ret = connection->write(buffer, PACKET_INFO_STRING_SIZE + 1);
    if (ret <0)
        return -1;

   if (quit)
      abort();

    return ret + ret2;
}



int Packet_info_string::write_to(Plug *connection, int _actor_type, int _actor_id, int _var_id, char const *_string)
{
    int ret = 0;
    int ret2 = 0;
    int l;
    l = strlen(_string);
    buffer[0] = TYPE_INFO_STRING;
    int2_to_string(_actor_type, buffer + 1);
    int4_to_string(_actor_id, buffer + 3);
    buffer[7] = _var_id;
    int2_to_string(l , buffer + 8);

    if ((ret = connection->write(buffer, PACKET_INFO_STRING_SIZE + 1))  < 0)
        return -1;

    if ((ret2 = connection->write(_string, l)) < 0)
        return -1;

       
    return ret + ret2;
    
}

char const *Packet_info_string::get_string() const
{
    return string_value;
}

void Packet_info_string::clear_string()
{
    if (string_value)
	delete string_value;
    string_value = NULL;
    string_length = max_string_length = 0;
}

void Packet_info_string::set_string(char const *string)
{
    if (string_value)
       delete string_value;

    string_value = sstrdup(string);
    max_string_length = string_length = strlen(string_value);
}


int Packet_info_string::expect(Packet const *_p, int _actor_type, int _actor_id, int _var_id, char const *_var_value)
{
    Packet_info_string const *p;

    if (!_p)
	return FALSE;
    if (_p->err)
    {
	warning("Packet_info_string::expect : error : %s", Packet::error);
	return FALSE;
    }

//   warning("expect stringp 1");
   
   if (_p->get_type() != TYPE_INFO_STRING)
      return FALSE;
//   warning("expect stringp 2");

   p = (Packet_info_string *)_p;

   if (_actor_type != NA && p->actor_type != _actor_type)
      return FALSE;
//   warning("expect stringp 3");

   if (_actor_id != NA && p->actor_id != _actor_id)
      return FALSE;
//   warning("expect stringp 4");

   if (_var_id != NA && p->var_id != _var_id)
      return FALSE;
      
//   warning("expect stringp 5");

   if (_var_value && strcmp(_var_value, p->get_string()))
      return FALSE;
//   warning("expect stringp ok, ghot to the end");

   return TRUE;

}

char Packet_info_string::buffer[PACKET_INFO_STRING_SIZE + 1];



Packet_info_string *new_packet_info_string()
{
    Packet_info_string *tmp;

    tmp = (Packet_info_string *)new_object(COMMON_FREELIST_PACKET_INFO_STRING);

    if (!tmp)
    {
	tmp = new Packet_info_string;
    }
    else
    {
	tmp->set(0, 0, 0, NULL);
    }

    return tmp;
}

Packet_info_string *new_packet_info_string(Packet_info_string const *other)
{
    Packet_info_string *tmp;

    tmp = (Packet_info_string *)new_object(COMMON_FREELIST_PACKET_INFO_STRING);

    if (!tmp)
    {
	tmp = new Packet_info_string;
    }

    tmp->set(other);

    return tmp;
}

Packet_info_string *new_packet_info_string(int actor_type, int actor_id, int var_id, char const *var_value)
{
    Packet_info_string *tmp;

    tmp = (Packet_info_string *)new_object(COMMON_FREELIST_PACKET_INFO_STRING);

    if (!tmp)
    {
	tmp = new Packet_info_string(actor_type, actor_id, var_id, var_value);
    }
    else
    {
	tmp->set(actor_type, actor_id, var_id, var_value);
    }

    return tmp;
}

/* the same function with an electron as first argument */
Packet_info_string *new_packet_info_string(Electron *actor, int _var_id, char const *_value)
{
    return new_packet_info_string(actor->actor_type,
				  actor->actor_id,
				  _var_id,
				  _value);
}


Packet_info_string *new_packet_info_string(Plug *connection)
{
    Packet_info_string *tmp;

    tmp = (Packet_info_string *)new_object(COMMON_FREELIST_PACKET_INFO_STRING);

    if (!tmp)
    {
	tmp = new Packet_info_string(connection);
    }
    else
    {
	tmp->set(connection);
    }

    return tmp;
}
