/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *   packt_in.cc
 *
 *   class implementation of Packet_info_num
 */

#include "packet.h"
#include <stdlib.h>
Packet_info_num::Packet_info_num()
{
    set(0, 0, 0, 0);
}


Packet_info_num::Packet_info_num(int _actor_type, int _actor_id,
				 int _var_id, int _var_value)
{
    set(_actor_type, _actor_id, _var_id, _var_value);
}

void Packet_info_num::set(int _actor_type, int _actor_id,
				 int _var_id, int _var_value)
{
    type = TYPE_INFO_NUM;
    freelist_index = COMMON_FREELIST_PACKET_INFO_NUM;
    
    actor_type = _actor_type;
    actor_id = _actor_id;
    var_id = _var_id;
    var_value = _var_value;
}

void Packet_info_num::set(Packet_info_num const *other)
{
    set(other->actor_type,
	other->actor_id,
	other->var_id,
	other->var_value);
}

Packet_info_num::Packet_info_num(Plug *connection)
{
    type = TYPE_INFO_NUM;
    freelist_index = COMMON_FREELIST_PACKET_INFO_NUM;
    
    set(connection);
}

void Packet_info_num::set(Plug *connection)
{
    read_from(connection);
}

Packet_info_num::~Packet_info_num()
{
    clear();
}

void Packet_info_num::clear()
{
    // do nothing
}

// read_from KNOWS that data is available, because the first
// byte of the packet has already been read. therefore it may
// retry until it reads the rest of the packet.
int Packet_info_num::read_from(Plug *connection)
{
    int result;

    while (!(result = connection->read(buffer, PACKET_INFO_NUM_SIZE)))
    {
	warning("Packet_info_num::read_from : no data, retrying");	
	continue;
    }
    
    if (result < PACKET_INFO_NUM_SIZE)
    {
        err = -1;
        ssprintf(Packet::error, 1024,
		"Error reading numeric info packet : read returns %d",
		result);
        return -1;
    }
    
    read_actor(buffer);  // reads 4 bytes from buffer
    var_id = buffer[6];
    var_value = int4_from_string(buffer + 7);

    return result;
}

int Packet_info_num::write_to(Plug *connection)
{
    buffer[0] = TYPE_INFO_NUM;
    write_actor(buffer + 1);
    buffer[7] = char(var_id);
    int4_to_string(var_value, buffer + 8);

    return connection->write(buffer, PACKET_INFO_NUM_SIZE + 1);
}

int Packet_info_num::write_to_bogus(Plug *connection, int quit)
{
    buffer[0] = TYPE_INFO_NUM;
    write_actor(buffer + 1);
    buffer[7] = char(var_id);
    int4_to_string(var_value, buffer + 8);

    int ret = connection->write(buffer, PACKET_INFO_NUM_SIZE/2 + 1);

    if (quit)
       abort();

    return ret;
}



int Packet_info_num::write_to(Plug *connection, int _actor_type,
			      int _actor_id, int _var_id, int _var_value)
{
    buffer[0] = TYPE_INFO_NUM;
    int2_to_string(_actor_type, buffer + 1);
    int4_to_string(_actor_id, buffer + 3);
    buffer[7] = (char)_var_id;
    int4_to_string(_var_value, buffer + 8);

    return connection->write(buffer, PACKET_INFO_NUM_SIZE + 1);
}

// return value is boolean:
// found expected packet = 1
// did not find expected packet = 0
int Packet_info_num::expect(Packet const *p, int _actor_type, int _actor_id,
			    int _var_id, int _var_value)
{
    Packet_info_num *pin;
    
    // start with checking if the packet is valid
    if (!p)
	return 0;
    if (p->err)
    {
	warning("Packet_info_num::expect : error : %s", Packet::error);
	return 0;
    }
    if (p->get_type() != TYPE_INFO_NUM)
	return 0;

    pin = (Packet_info_num *)p;

    // check the contents, only if the parameters are applicable
    if (_actor_type != NA)
    {
	if (pin->actor_type != _actor_type)
	    return 0;
    }
    if (_actor_id != NA)
    {
	if (pin->actor_id != _actor_id)
	    return 0;
    }
    if (_var_id != NA)
    {
	if (pin->var_id != _var_id)
	    return 0;
    }
    if (_var_value != NA)
    {
	if (pin->var_value != _var_value)
	    return 0;
    }

    // everything matched, or was not applicable
    return 1;
}

char Packet_info_num::buffer[PACKET_INFO_NUM_SIZE + 1];



Packet_info_num *new_packet_info_num()
{
    Packet_info_num *tmp;

    tmp = (Packet_info_num *)new_object(COMMON_FREELIST_PACKET_INFO_NUM);

    if (!tmp)
    {
	tmp = new Packet_info_num();
    }
    else
    {
	tmp->set(0,0,0,0);
    }

    return tmp;
}

Packet_info_num *new_packet_info_num(Packet_info_num const *other)
{
    Packet_info_num *tmp;

    tmp = (Packet_info_num *)new_object(COMMON_FREELIST_PACKET_INFO_NUM);

    if (!tmp)
    {
	tmp = new Packet_info_num;
    }

    tmp->set(other);

    return tmp;
}

Packet_info_num *new_packet_info_num(int actor_type, int actor_id, int var_id, int var_value)
{
    Packet_info_num *tmp;

    tmp = (Packet_info_num *)new_object(COMMON_FREELIST_PACKET_INFO_NUM);

    if (!tmp)
    {
	tmp = new Packet_info_num(actor_type, actor_id, var_id, var_value);
    }
    else
    {
	tmp->set(actor_type, actor_id, var_id, var_value);
    }

    return tmp;
}

/* the same function with an Electron as the first argument */
Packet_info_num *new_packet_info_num(Electron *actor, int _var_id, int _var_value)
{
    return new_packet_info_num(actor->actor_type,
			       actor->actor_id,
			       _var_id,
			       _var_value);
}


Packet_info_num *new_packet_info_num(Plug *connection)
{
    Packet_info_num *tmp;

    tmp = (Packet_info_num *)new_object(COMMON_FREELIST_PACKET_INFO_NUM);

    if (!tmp)
    {
	tmp = new Packet_info_num(connection);
    }
    else
    {
	tmp->set(connection);
    }

    return tmp;
}
