/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 * packt_c.cc
 * implementation of the Packet_command class
 */
#include "packet.h"
#include <stdlib.h>

Packet_command::Packet_command()
{
    set(0, 0, 0, 0, 0, 0, 0, 0);
}


Packet_command::Packet_command(int _actor_type, int _actor_id, int _command, int _arg1, int _arg2, int _arg3, int _arg4, int _arg5)
{
    set(_actor_type, _actor_id, _command, _arg1, _arg2, _arg3, _arg4, _arg5);
}

void Packet_command::set(int _actor_type, int _actor_id, int _command, int _arg1, int _arg2, int _arg3, int _arg4, int _arg5)
{
    type = TYPE_COMMAND;
    freelist_index = COMMON_FREELIST_PACKET_COMMAND;

    actor_type = _actor_type;
    actor_id = _actor_id;
    command = _command;
    arg1 = _arg1;
    arg2 = _arg2;
    arg3 = _arg3;
    arg4 = _arg4;
    arg5 = _arg5;
}

void Packet_command::set(Packet_command const *other)
{
    set(other->actor_type,
	other->actor_id,
	other->command,
	other->arg1,
	other->arg2,
	other->arg3,
	other->arg4,
	other->arg5);
}

void Packet_command::set(Plug *connection)
{
    type = TYPE_COMMAND;
    freelist_index = COMMON_FREELIST_PACKET_COMMAND;
    
    read_from(connection);
}

Packet_command::Packet_command(Plug *connection)
{
    set(connection);
}

Packet_command::~Packet_command()
{
    clear();
}

void Packet_command::clear()
{
    // do nothing
}

// read_from KNOWS that data is available, because the first
// byte of the packet has already been read. therefore it may
// retry until it reads the rest of the packet.
int Packet_command::read_from(Plug *connection)
{
    int ret;
    while (!(ret = connection->read(buffer,PACKET_COMMAND_SIZE)))
    {
        warning("Packet_command::read_from : no data, retrying");
        continue;
    }

    if (ret < PACKET_COMMAND_SIZE)
    {
        err = -1;
        ssprintf(Packet::error, 1024,
                "Error reading command packet: read returns %d",
                ret);
        return -1;
    }
    
    read_actor(buffer);
    command = buffer[6];
    arg1 = int2_from_string(buffer+7);
    arg2 = int2_from_string(buffer+9);
    arg3 = int2_from_string(buffer+11);
    arg4 = int2_from_string(buffer+13);
    arg5 = int2_from_string(buffer+15);

    return ret;
}

int Packet_command::write_to(Plug *connection)
{
    buffer[0] = (char)TYPE_COMMAND;
    write_actor(buffer + 1);
    buffer[7] = (char)command;
    int2_to_string(arg1, buffer + 8);
    int2_to_string(arg2, buffer + 10);
    int2_to_string(arg3, buffer + 12);
    int2_to_string(arg4, buffer + 14);
    int2_to_string(arg5, buffer + 16);
    return connection->write(buffer, PACKET_COMMAND_SIZE + 1);
}


int Packet_command::write_to_bogus(Plug *connection, int quit)
{
    buffer[0] = (char)TYPE_COMMAND;
    write_actor(buffer + 1);
    buffer[7] = (char)command;
    int2_to_string(arg1, buffer + 8);
    int2_to_string(arg2, buffer + 10);
    int2_to_string(arg3, buffer + 12);
    int2_to_string(arg4, buffer + 14);
    int2_to_string(arg5, buffer + 16);
    int ret = connection->write(buffer, PACKET_COMMAND_SIZE/2 + 1);

    if (quit)
       abort();

    return ret;
    
}


int Packet_command::write_to(Plug *connection, int _actor_type, int _actor_id, int _command, int _arg1, int _arg2, int _arg3, int _arg4, int _arg5)
{
    buffer[0] = (char)TYPE_COMMAND;
    int2_to_string(_actor_type, buffer + 1);
    int4_to_string(_actor_id, buffer + 3);
    
    buffer[7] = (char)_command;
    int2_to_string(_arg1, buffer + 8);
    int2_to_string(_arg2, buffer + 10);
    int2_to_string(_arg3, buffer + 12);
    int2_to_string(_arg4, buffer + 14);
    int2_to_string(_arg5, buffer + 16);
    return connection->write(buffer, PACKET_COMMAND_SIZE + 1);
}


int Packet_command::write_to_ssl(Plug *connection, int _actor_type, int _actor_id, int _command, int _arg1,int _arg2, int _larg2, int _arg5)
{
    int _arg3, _arg4;

    long2shorts(_larg2, &_arg3, &_arg4);
    
    buffer[0] = (char)TYPE_COMMAND;
    int2_to_string(_actor_type, buffer + 1);
    int4_to_string(_actor_id, buffer + 3);


    
    buffer[7] = (char)_command;
    int2_to_string(_arg1, buffer + 8);
    int2_to_string(_arg2, buffer + 10);
    int2_to_string(_arg3, buffer + 12);
    int2_to_string(_arg4, buffer + 14);
    int2_to_string(_arg5, buffer + 16);
    return connection->write(buffer, PACKET_COMMAND_SIZE + 1);
}

int Packet_command::write_to_ll(Plug *connection, int _actor_type, int _actor_id, int _command, int _larg1, int _larg2, int _arg5)
{
    int _arg1, _arg2;
    int _arg3, _arg4;

    long2shorts(_larg1, &_arg1, &_arg2);
    long2shorts(_larg2, &_arg3, &_arg4);
    
    buffer[0] = (char)TYPE_COMMAND;
    int2_to_string(_actor_type, buffer + 1);
    int4_to_string(_actor_id, buffer + 3);


    
    buffer[7] = (char)_command;
    int2_to_string(_arg1, buffer + 8);
    int2_to_string( 0, buffer + 10); // unused
    int2_to_string(_arg3, buffer + 12);
    int2_to_string(_arg4, buffer + 14);
    int2_to_string(_arg5, buffer + 16);
    return connection->write(buffer, PACKET_COMMAND_SIZE + 1);
}


// return value is boolean:
// found expected packet = 1
// did not find expected packet = 0
int Packet_command::expect(Packet const *p,
                           int _actor_type, int _actor_id,
                           int _command, int _arg1, int _arg2,
                           int _arg3, int _arg4, int _arg5)
{
    Packet_command *pco;

    if (!p)
        return 0;
    if (p->err)
    {
        warning("Packet_command::expect : error : %s", Packet::error);
        return 0;
    }
    if (p->get_type() != TYPE_COMMAND)
        return 0;

    pco = (Packet_command *)p;
    
    // check the contents, only if the parameters are applicable
    if (_actor_type != NA)
    {
        if (pco->actor_type != _actor_type)
            return 0;
    }
    if (_actor_id != NA)
    {
        if (pco->actor_id != _actor_id)
            return 0;
    }
    if (_command != NA)
    {
        if (pco->command != _command)
            return 0;
    }
    if (_arg1 != NA)
    {
        if (pco->arg1 != _arg1)
            return 0;
    }
    if (_arg2 != NA)
    {
        if (pco->arg2 != _arg2)
            return 0;
    }
    if (_arg3 != NA)
    {
        if (pco->arg3 != _arg3)
            return 0;
    }
    if (_arg4 != NA)
    {
        if (pco->arg4 != _arg4)
            return 0;
    }
    if (_arg5 != NA)
    {
        if (pco->arg5 != _arg5)
            return 0;
    }

    // everything matched, or was not applicable
    return 1;
}

char Packet_command::buffer[PACKET_COMMAND_SIZE + 1];


Packet_command *new_packet_command()
{
    Packet_command *tmp;

    tmp = (Packet_command *)new_object(COMMON_FREELIST_PACKET_COMMAND);

    if (!tmp)
    {
        tmp = new Packet_command();
    }
    else
    {
        tmp->set(0,0,0,0,0,0,0,0);
    }

    return tmp;
}

Packet_command *new_packet_command(Packet_command const *other)
{
    Packet_command *tmp;

    tmp = (Packet_command *)new_object(COMMON_FREELIST_PACKET_COMMAND);

    if (!tmp)
    {
	tmp = new Packet_command;
    }

    tmp->set(other);

    return tmp;
}

Packet_command *new_packet_command(int actor_type, int actor_id, int command, int arg1, int arg2, int arg3, int arg4, int arg5)
{
    Packet_command *tmp;

    tmp = (Packet_command *)new_object(COMMON_FREELIST_PACKET_COMMAND);

    if (!tmp)
    {
        tmp = new Packet_command(actor_type, actor_id, command, arg1, arg2, arg3, arg4, arg5);
    }
    else
    {
        tmp->set(actor_type, actor_id, command, arg1, arg2, arg3, arg4, arg5);
    }

    return tmp;
}

Packet_command *new_packet_command(int actor_type, int actor_id, int command, int arg1, int arg2, int longarg, int arg5)
{
    Packet_command *tmp;

    int arg3, arg4;

    Packet_command::long2shorts(longarg, &arg3, &arg4);

    tmp = (Packet_command *)new_object(COMMON_FREELIST_PACKET_COMMAND);

    if (!tmp)
    {
        tmp = new Packet_command(actor_type, actor_id, command, arg1, arg2, arg3, arg4, arg5);
    }
    else
    {
        tmp->set(actor_type, actor_id, command, arg1, arg2, arg3, arg4, arg5);
    }

    return tmp;
}


/* the same function with a Electron * as first argument */
Packet_command *new_packet_command(Electron *actor, int _command, int _arg1, int _arg2, int _arg3, int _arg4, int _arg5)
{
    return new_packet_command(actor->actor_type,
                              actor->actor_id,
                              _command,
                              _arg1,
                              _arg2,
                              _arg3,
                              _arg4,
                              _arg5);
}

/* the same function with a Electron * as first argument , but wrapping up arg3, arg4 to one unsigned long*/
Packet_command *new_packet_command(Electron *actor, int _command, int _arg1, int _arg2, int longarg, int _arg5)
{
    return new_packet_command(actor->actor_type,
                              actor->actor_id,
                              _command,
                              _arg1,
                              _arg2,
                              longarg,
                              _arg5);
}

Packet_command *new_packet_command(Electron *actor, int _command, Electron *actor2, int _arg5)
{
    return new_packet_command(actor->actor_type,
                              actor->actor_id,
                              _command,
                              actor2->actor_type,
                              0,
                              actor2->actor_id,
                              _arg5);
}

Packet_command *new_packet_command(Plug *connection)
{
    Packet_command *tmp;

    tmp = (Packet_command *)new_object(COMMON_FREELIST_PACKET_COMMAND);

    if (!tmp)
    {
        tmp = new Packet_command(connection);
    }
    else
    {
        tmp->set(connection);
    }

    return tmp;
}

unsigned int Packet_command::shorts2long(int s1, int s2)
{
    unsigned int ret = s1;

    ret <<= 16;

    ret |= s2;

    return ret;
}

void Packet_command::long2shorts(int l1, int *s1, int *s2)
{

   *s2 = l1 & 0xFFFF;
   *s1 = l1 >> 16;
}

void Packet_command::set_larg1(unsigned int arg)
{
   long2shorts(arg, &arg1, &arg2);
}

void Packet_command::set_larg2(unsigned int arg)
{
   long2shorts(arg, &arg3, &arg4);
}

unsigned int Packet_command::larg1()  const
{
   return shorts2long(arg1, arg2);
}

unsigned int Packet_command::larg2()  const
{
   return shorts2long(arg3, arg4);
}

