/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */


#include "object.h"
#include "utils.h"

#ifdef DEBUGMODE
#include "common.h"
#include <typeinfo>
#endif

Object::Object()
{
    freelist_index = -1;
    #ifdef DEBUGMODE
    list_refcount = 0; // how many lists is this object in
    #endif
}

Object::~Object()
{
     clear();
     
#ifdef DEBUGMODE
     if (freelist_index >= 0)
     {
	 fatal("Object of type %s deleted while it should be recycled!", typeid(*this).name());
     }
#endif

     ASSERT(freelist_index < 0);
}

void Object::clear()
{
     #ifdef DEBUGMODE
     if (!going_down)
     {
        ASSERT(!list_refcount); // object may never be in a list when destroyed
     }
     #endif
}

