/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 * class definition of Lattice
 * as the reader might have noticed we have spent quite some time doing
 * solid-state physics exams.
 * Our map contains units which contain a cloud of objects (well, a lot
 * of objects anyway) so we have a Lattice of Atoms which each have
 * clouds of Electrons.
 */

#ifndef _LATTICE_H_
#define _LATTICE_H_

#include "atom.h"

class Lattice : public Object
{
 public:
    Lattice(int width, int height);
    ~Lattice();

    Atom *get(int x, int y);
    int set(Atom *a, int x, int y); // 0 = failure, 1 = succes
    void clear(int x, int y);
    int get_w() { return w; };
    int get_h() { return h; };
    int add(Electron *e, int x, int y);
    int remove(Electron *e, int x, int y);
    Electron *find(int type,  unsigned int id);
    // move an electron the inventory of a new parent
    // taking it out where it currently is
    void move_electron(Electron *e, Electron *new_parent);

    void get_reset(int *x, int *y);
    void set_reset(int x, int y);

    void get_vote(int *x, int *y);
    void set_vote(int x, int y);

    // get a random room
    Atom *get_random_atom(Electron *entrant = 0);
    
 protected:
    Atom ***lattice;
    int w, h;
    int reset_x, reset_y;
    int vote_x, vote_y;
};

extern Lattice *lattice;

#endif

