/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *      freelist.h
 *
 *      declaration of everything that has to do with freelists in
 *      the common library. there is a global system for adding free_lists:
 *      common makes COMMON_FREELIST_LAST freelists. each program can define
 *      as many freelists as they want (MY_FREELIST_LAST) and call
 *      init_freelists(MY_FREELIST_LAST). after that the requested number
 *      of freelists has been defined.
 *
 *      functions new_object(List#) and delete_object(List#, Object*)
 *      are now available for use. keep in mind that List# has to be
 *      COMMON_FREELIST_LAST + list_index if you are using your own lists.
 *      the common lists are stored as lists [0, COMMON_FREELIST_LAST>.
 *
 *      write macro functions as shown (new_player, delete_player, etc)
 *      for easy use.
 */

#ifndef _COMMON_FREELIST_H_
#define _COMMON_FREELIST_H_

#include "list.h"

enum common_freelists
{
    COMMON_FREELIST_INVALID = -1,
    COMMON_FREELIST_PACKET = 0,
    COMMON_FREELIST_ATOM,
    COMMON_FREELIST_PACKET_INFO_NUM,
    COMMON_FREELIST_PACKET_INFO_STRING,
    COMMON_FREELIST_PACKET_INFO_VECT,
    COMMON_FREELIST_PACKET_COMMAND,
    COMMON_FREELIST_SYSTEM,
    COMMON_FREELIST_PLAYER,
    COMMON_FREELIST_SIMPLE_ROOM,
    COMMON_FREELIST_LIGHTCYCLE,
    COMMON_FREELIST_KEY,
    COMMON_FREELIST_CYCLEWALL,
    COMMON_FREELIST_TANK,
    COMMON_FREELIST_GRENADE,
    COMMON_FREELIST_EXPLOSION,
    COMMON_FREELIST_LAUNCHER,
    COMMON_FREELIST_BLUE_BALL,
    COMMON_FREELIST_YELLOW_BALL,
    COMMON_FREELIST_RED_BALL,
    COMMON_FREELIST_HOVER,
    COMMON_FREELIST_LASERBEAM,
    COMMON_FREELIST_MINE,
    COMMON_FREELIST_DOOR,
    COMMON_FREELIST_WATER,
    COMMON_FREELIST_DOORKEY,
    COMMON_FREELIST_AMBULANCE,
    COMMON_FREELIST_MEDICAL_PAD,
    COMMON_FREELIST_AMMO_PAD,
    COMMON_FREELIST_REPAIR_PAD,
    COMMON_FREELIST_ROUTEPLANNER,
    COMMON_FREELIST_FIETSENMAKER,
    COMMON_FREELIST_WEAPONSMITH,
    COMMON_FREELIST_VOTE_ROOM,
    COMMON_FREELIST_VOTEMACHINE,
    COMMON_FREELIST_WEAPONMACHINE,
    COMMON_FREELIST_SAFE_ROOM,
    COMMON_FREELIST_LAST
};

extern void init_freelists(int number_lists);
extern void cleanup_freelists();
extern Object *new_object(int list_nr);
extern void delete_object(Object *obj);

//deletes all objects in a List, all objecvts must be 'freelist-able'
extern void delete_objects(List *l);

/* debugging stuff */
// nr of freelists in use
extern int nr_freelists;
class Freelist_info
{
    public:
           Freelist_info();
           int nr_hits; // nr of allocations done from the List
           int nr_misses; // nr of allocations from empty List (failed)
           int nr_frees; // nr elements returned to List
           int list_size; // List size (= nr_frees - nr_hits)
           // the total nr of elements in use should always be equal to nr_misses
           // if at any time nr_misses < list_size there's something wrong
           // if nr_misses == list_size all elements are in the List , and none in use
};

extern Freelist_info *freelist_info;
extern void dump_freelist_stats();



#endif
