#include "fork.h"
#include "packet.h"


Fork::Fork()
{
   num_lists = 0;
}


Fork::~Fork()
{

 List::reset();
 while(List::pop());
}


void Fork::add(List *l)
{
   List::push(l);
   num_lists++;

}

void Fork::remove(List *l)
{
   if (!(List::pop(l)))
      fatal("cannot remove list from Fork because it isn't in the Fork");
      
   num_lists--;
}


void Fork::push(Object *other)
{
    Packet *p;
    int nl = num_lists;
    List *l;
    
    p = dynamic_cast<Packet *>(other);




    if (!p)
        fatal("Fork only understands about packets");
    
    if (!num_lists)
    {
        delete_object(other);     //! this to prevent memory leaks
        return;
    }
   
    List::reset();
    while(nl>1)
    {
        l = (List *)List::get();
        
        ASSERT(l);
        
        l->push(new_packet(p));
        
       
        List::next();
        nl--;
    }
    
    if (num_lists)
    {
        ASSERT(nl==1);
        l = (List *)List::get();
        ASSERT(l);
        l->push(p);
    }
}
