/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 * setup/shutdown functions of the common library
 */

#include <stdio.h>
#include "common.h"
#include "utils.h"
#include "freelist.h"
#include "act_type.h"
#include "permissions.h"
#include "packet.h"
#include "atom.h"
/* initialise the common library*/


char logo[] =
    "\n"
    "    ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^ \n"
    "   /|\\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\\\n"
    "    |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   | \n"
    "    |  \\|/   s     p   d     f   f   g   h   h i   i j  jj   \\|/  | \n"
    "    |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   | \n"
    "                                                                    \n"
    "               for copyright/licence info see README.txt            \n"
    "                   Martijn Versteegh & Hein Zelle                   \n\n";

int going_down = FALSE;

int init_common(int freelists)
{
    init_freelists(freelists);
    init_translate_types();
    init_permissions();
    init_global_actor_statics();
    init_global_packets();         // no exit function
    storage = new Atom;            // no need to use freelist functions, we'll have only one
    storage->freelist_index = -1;
    return 0;
}

/* cleanup common library*/
void shutdown_common()
{
    storage->delete_objects();
    delete storage;
    shutdown_global_packets();
    shutdown_global_actor_statics();
    shutdown_permissions();
    shutdown_translate_types();
    cleanup_freelists();
}

#ifdef _USE_LIBNET_

static int libnet_initialised = 0;

int init_libnet()
{
    NET_DRIVERLIST drivers;
    NET_DRIVERLIST result;
    NET_DRIVERLIST result2;

    if (libnet_initialised++)
	return libnet_initialised;
    
    net_init();
    
    drivers = net_driverlist_create();
    net_driverlist_add(drivers, NET_DRIVER_SOCKETS);

    result = net_detectdrivers(drivers);
    if (!result)
    {
	fatal("init_libnet: net_detectdrivers failed");
    }
    
    result2 = net_initdrivers(result);
    if (!result2)
    {
	fatal("init_libnet: net_initdrivers failed");
    }

    warning("libnet initialised");
    
    return libnet_initialised;
}

void shutdown_libnet()
{
    if (--libnet_initialised)
	return;
    
    net_shutdown();

    warning("libnet shutdown");
}

#endif
