/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       commands.h
 *
 *       enum defining all possible commands to be sent in a Packet_command
 */

#ifndef _COMMON_PACKET_COMMANDS_H_
#define _COMMON_PACKET_COMMANDS_H_

// arg1, arg2, arg3, arg4, arg5 ( = time )
enum packet_commands
{
    COMMAND_FROM_TO = 0,  // xf, yf, xt, yt
    COMMAND_TO,           // xt, yt, ??, ??
    COMMAND_DIR,          // dir, ??, ??, ??
    COMMAND_TO_PLAYER,    // player_id, ??, ??, ??
    COMMAND_PICKUP,       // type, id, ??, ??
    COMMAND_DROP,         // type, id, ??, ??                  // 5
    COMMAND_ENTER,        // type, id, ??, ??
    COMMAND_EXIT,         // ??, ??, ??, ??
    COMMAND_TURN,         // dir, ??, ??, ??
    COMMAND_FIRE_TO,      // xt, yt, ??, ??
    COMMAND_FIRE_DIR,     // dir, ??, ??, ??                   // 10
    COMMAND_FIRE_AT,      // target_type, target_id, ??, ??
    COMMAND_LAY_MINE,     // ??, ??, ??, ??
    COMMAND_OPEN,         // dir, ??, ??, ??
    COMMAND_CLOSE,        // dir, ??, ??, ??
    COMMAND_UNLOCK,       // dir, ??, ??, ??                   // 15
    COMMAND_LOCK,         // dir, ??, ??, ??
    COMMAND_VOTE,         // gametype, ??, ??, ??
    COMMAND_GAMETIME,     // ??, ??, ??, ??
    COMMAND_WEAPON,       // weapontype, ??, ?/, ??
    COMMAND_RIG,          // vehicle_type, vehicle_id, ??, ??  // 20
    COMMAND_SELFDESTRUCT, // vehicle_type, vehicle_id, ??, ??
};

#endif
