/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     atom.h
 *
 *     class definition of the Atom
 *     the Atom class represents a lattice element, and contains
 *     several lists of objects (electrons) representing a room,
 *     the objects in the room, the players in the room, etc.
 */

#ifndef _ATOM_H_
#define _ATOM_H_

#include <stdlib.h>
#include "object.h"
#include "list.h"
#include "electron.h"
#include "freelist.h"
#include "defs.h"

enum list_types
{
    LIST_ROOM = 0,
    LIST_PLAYER,
    LIST_VEHICLE,
    LIST_KEY,
    LIST_MISC,
    LIST_BULLET,
    LIST_WEAPON,
    LIST_PAD,
    LIST_LAST                // LIST_LAST is an invalid index!
};


class Atom : public Object
{
public:
    Atom();
    ~Atom();

    void set();    // accessible constructor
    void clear();  // accesible destructor

    void delete_objects();  // delete(to freelist) all data in the lists.
                            // careful!
    
    List *operator[](int index);
    List *get(int index);

    // the lowlevel_ functions don't add the electron to the inventory of
    // an already present electron, they do add all objects
    // in the inventory of the passed electron to the
    // sorted lists in the electron
    int lowlevel_add(Electron *e);
    int lowlevel_remove(Electron *e);

    // adds an electron to the atom, hanging it in the inventory of parent
    // if parent is not NULL, if parent is NULL, and the Object already
    // contains a top_level Object, a warning is generated.
    int add(Electron *e, Electron *parent = NULL);

    // removes an electron from an atom, also removes it from
    // the inventory of it's parent
    int remove(Electron *e);

    // find looks for a specific electron
    // find_type looks for the first one with the given type
    // both return 0 if they cannot find it
    Electron *find(unsigned int actor_type,  unsigned int id);
    Electron *find_type(unsigned int actor_type);
    
    //! moet eigenlijk private, met get functie
    Electron *top_level_object;
    int x,y;
protected:
    List contents[LIST_LAST];

};

extern Atom *new_atom();

extern Atom *storage;

#endif
