/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        weapon.h
 *
 *        class declaration of a Weapon
 *        Weapon is the base class for all weapons
 */

#ifndef _WEAPON_H_
#define _WEAPON_H_

#include "common/electron.h"

class Weapon : public Electron
{
public:
    Weapon(int _actor_type = 0, int _actor_id = 0);

    void set(int _actor_type, int _actor_id);
    void clear();
    
    int is_group(int group) const;

    int get_reloading();
    void set_reloading(int yesno);
    
protected:
    int reloading;
    int reload_time;
    float fire_range;
    int flight_time;
};


#endif

