/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        weapon.cc
 *
 *        class implementation of a Weapon
 *        Weapon is the base class for all weapons
 */

#include "weapon.h"

Weapon::Weapon(int _actor_type, int _actor_id)
{
    set(_actor_type, _actor_id);
}

void Weapon::set(int _actor_type, int _actor_id)
{
    Electron::set(_actor_type, _actor_id);

    reload_time = 0;
    reloading = 0;
    flight_time = 0;
    fire_range = 0.0;
}

void Weapon::clear()
{
    Electron::clear();
    reload_time = 0;
    reloading = 0;
    flight_time = 0;
    fire_range = 0.0;
}

int Weapon::is_group(int group) const
{
    return (group == GROUP_WEAPON);
}

int Weapon::get_reloading()
{
    return reloading;
}

void Weapon::set_reloading(int yesno)
{
    reloading = yesno;
}
