/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */


#ifndef _VEHICLE_H_
#define _VEHICLE_H_

#include "common/electron.h"

class Key;
class Player;

class Vehicle : public Electron
{
public:
    Vehicle(int _actor_type = 0, int _actor_id = 0);

    void set(int _actor_type = 0, int _actor_id = 0);
    void clear();
    
    virtual int turn(int dir);
    virtual int move_to(int x, int y, Electron *pl);
    virtual int move_dir(int dir, Electron *pl);
    virtual int is_group(int group) const;
    virtual int can_be_entered(Electron const *other) const;

    void add_key(Key *k);
    void del_key(Key *k);
    int has_key();                // does the vehicle have a key (or more)
    int owns_key(Player *pl);     // does the player have one of the keys?
    
    int drive_time;
    int turn_time;
    int facing;
    int bomb;                     // is the vehicle armed with a bomb?
    
protected:
    List keys;
};

#endif
