/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *
 *
 *
 */


#include "vehicle.h"
#include "common/atom.h"
#include "common/act_type.h"
#include "common/actors/key.h"
#include "common/actors/player.h"

Vehicle::Vehicle(int _actor_type, int _actor_id)
{
    set(_actor_type,_actor_id);
}

void Vehicle::set(int _actor_type, int _actor_id)
{
    // just pass it on to electron (this is just a base class for all vehicles)
    Electron::set(_actor_type, _actor_id);
    keys.clear();     // clean up the List of keys
    turn_time = 0;
    drive_time = 0;
    facing = 1;
    bomb = 0;
}

void Vehicle::clear()
{
    Key *k;
    
    Electron::clear();

    // clear the key List
    keys.reset();
    while ((k = (Key *)keys.get()))
    {
	k->set_vehicle(0);
	keys.next();
    }
    keys.clear();

    turn_time = drive_time = facing = bomb = 0;
}

int Vehicle::is_group(int group) const
{
    if (group == GROUP_VEHICLE)
       return -1;

    return 0;
}

int Vehicle::can_be_entered(Electron const *other) const
{
    // if it's allowed to be in a player, then it's allowed in a vehicle too
    if (global_actor_statics[ACTOR_PLAYER]->can_be_entered(other))
    {
	return -1;
    }

    if (other->actor_type == ACTOR_PLAYER)
    {
	return -1;
    }
    
    return 0;
}

void Vehicle::add_key(Key *k)
{
    keys.ifnotfoundpush(k);
}

void Vehicle::del_key(Key *k)
{
    keys.pop(k);
}

// do we have one or more keys?
int Vehicle::has_key()
{
    if (keys.get_head())
	return 1;

    return 0;
}

// 1 = yes, 0 = no
int Vehicle::owns_key(Player *pl)
{
    Key *k;

    keys.reset();
    while ((k = (Key *)keys.get()))
    {
	// if one of the keys is in the players inventory, return success
	if (pl->inv_contains_recursive(k))
	    return 1;
	
	keys.next();
    }

    return 0;
}

int Vehicle::move_to(int x, int y, Electron *pl)
{
    return 0;
}

int Vehicle::move_dir(int dir, Electron *pl)
{
    return 0;
}

int Vehicle::turn(int dir)
{
    int spent;

    // prevent invalid directions
    dir = abs(dir) % 4;
    
    // rotate the vehicle, determine the time it takes
    if (facing == dir)
    {
	// we don't need to turn
	spent = 0;
	warning("Vehicle::turn : no need to turn");
    }
    else
    if ((facing % 2) == (dir % 2))
    {
	// we're turning 180 degrees
	spent = turn_time * 2;  // 2 * 90 degree turn
	warning("Vehicle::turn : turning 180 degrees");
    }
    else
    {
	// we're turning 90 degrees
	spent = turn_time;   // 0.5 seconds turning time
	warning("Vehicle::turn : turning 90 degrees");
    }

    facing = dir;
    
    return spent;
}

