/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         tank.h
 *
 *         class definition of the Tank
 */

#ifndef _TANK_H_
#define _TANK_H_

#include "common/electron.h"
#include "common/utils.h"
#include "vehicle.h"

class Tank : public Vehicle
{
public:
    
    enum _int_vars
    {
	HMD_ENUM,
	DOOR,
	AMMO,
	INTVARS_LAST
    };
    enum _string_vars
    {
	STRINGVARS_LAST = 0
    };
    enum _vector_vars
    {
	VECTORVARS_LAST = 0
    };

    Tank();
    void set(int _actor_id);
    void clear() { Vehicle::clear(); }
    
    virtual int can_be_entered(Electron const *other) const;
    virtual void door(int d) const;  // let Stank know the door was closed
    virtual int max_ammo() { return 20; }
    
    // Tank has HMD
    HMD_PROTO;
    WRITE_HMD_PROTO;
    // make sure this class overloads the write_vars function.
    VARS_PROTO;
    
    int int_vars[INTVARS_LAST];

    // not used
    char *string_vars[STRINGVARS_LAST];
    Vector vector_vars[VECTORVARS_LAST];
};

#endif
