/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         tank.cc
 *
 *         class implementation of the Tank
 */

#include "tank.h"
#include "common/defs.h"

Tank::Tank()
{
    set(-1);
}

void Tank::set(int _actor_id)
{
    Vehicle::set(ACTOR_TANK, _actor_id);

    type_name = "tank";
    freelist_index = COMMON_FREELIST_TANK;

    set_hmd(1000, 300, 600);
    int_vars[DOOR] = 0;                         // 1 = closed, 0 = open
    int_vars[AMMO] = max_ammo();                // 20 grenades
}

int Tank::can_be_entered(Electron const *other) const
{
    // check Vehicle's can_be_entered first
    if (Vehicle::can_be_entered(other))
    {
	// check the door
	if (int_vars[DOOR] && other->actor_type == ACTOR_PLAYER)
	{
	    // we're closed : no go
	    // this only goes for players to prevent weird effects:
	    // drop a key in the tank:
	    // sorry, no can do, the hatch is closed
	    door(int_vars[DOOR]);
	    return 0;
	}
	else
	{
	    // everything ok and the door is open
	    return 1;
	}
    }
    
    return 0;
}

void Tank::door(int d) const
{
    warning("Tank::door");
    return;
}

// macro functions for write_vars and write_hmd
VARS_FUNCTION(Tank)
WRITE_HMD_FUNCTION(Tank)
