/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 * System actor header file
 * the system actor is not a real actor
 * and there is only one, with actor_type = TYPE_SYSTEM and actor_id == SYS_VAR
 * in this actor all global game variables are stored.
 * It is (ab)used as a handle to get to all game data
 * even though for example the lattice is not really in it
 * (you need to set it up yourself, and set the pointer in system)
 * The only reason this is an actor is because the communication
 * protocol reserves  actor_type 0 for system communication
 */

#ifndef _SYSTEM_H_

#define _SYSTEM_H_

#include "common/electron.h"
#include "common/lattice.h"
#include "common/vector.h"

#define SYS_VAR       0
#define SYS_MESSAGE   1

#define SYS_YES       1
#define SYS_NO        0

class System : public Electron
{
 public:
    enum _intvars
    {
        VERSION_INT = 0,
        NUM_PLAYERS,
        INTVARS_LAST
    };
    enum _stringvars
    {
        VERSION_STRING = 0,
        GAME_NAME,
        MAP_NAME,
        STRINGVARS_LAST
    };
    enum _vectorvars
    {
        MAP_SIZE = 0,
        VECTORVARS_LAST
    };

    System();
    void set(int actor_id);
    void clear();

    void set_int_var(int var_id, int val);
    void set_vector_var(int var_id, Vector v);
    void set_string_var(int var_id, char const *string);
    char const *get_string_var(int var_id) const;

    int int_vars[INTVARS_LAST];
    Vector vector_vars[VECTORVARS_LAST];
    
    /* these enum's members should be used with actor id == SYS_MESSAGE
     * and actor_type == ACTOR_SYSTEM
     * this is a special case which does not work the standard way
     * so when you get a packet about a ACTOR_SYSTEM you need
     * to check the player id
     * some conventions:
     * STC = server to client
     * CTS = client to server
     *
     */
    enum other_comm
    {   /* all are sent using info_num packets, except where stated otherwise */
        WRONG_VERSION_NUMBER = 0,    /* client and server need the same communication  */
        STC_I_AM_FULL_GET_LOST,      /* the server is full */
        STC_MAP_NAME,                /* the server sends map name (string packet)*/
        STC_MAP_DIMS,                /* the server sends map dimensions, abusing var_id to stor x dim and var_value to store y */
        STC_RESET_MAP,               /* the server is about to send a fresh map, so the client should delete it's current one */
        STC_YOU_ARE,                 /* the server sends the actor ID of the client's player in var_value */
        STC_PLAYER_NAME,             /* server sends a player name (string packet)*/
        STC_YER_DEAD,                /* server tells a player they died */
        CTS_MY_NAME,                 /* client sends it's players name in var_value (string packet)*/
        CTS_INTERESTED_YN,           /* client doesn't like this game, or does (depending on var_value) */
        PING_ARE_YOU_THERE,          /* various checks to see if the other side of the connection is still alive */
        PING_YES_IM_HERE,            /* sent in immediate reply to the above */
        PING_NO_IM_NOT,              /* sent by the server if the client pings excessively, 3 NO_IM_NOT's in row and you'll be kicked out */
        HANGUP,                      /* please hangup (the other side will) */
        CTS_SHUTDOWN,                /* client tells server to do a shutdown (need to check player's privileges) */
        STC_MESSAGE,                 /* server sends a message string */
	INVALID_PACKET,              /* notify the other side an invalid packet was received */
	BOUNCE_NEXT_PACKET,          /* bounce back the next packet. test. */
        OTHER_COMM_LAST
    };

    
protected:
    char * string_vars[STRINGVARS_LAST];
};


extern System *sys;


#endif
