/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *      system.cc
 *
 *      class implementation of the System actor type
 */


#include "system.h"
#include "common/version.h"
#include "common/utils.h"

System::System()
{
    // blah. this makes things much more consequent but it is
    // really a bit of a waste.
    freelist_index = COMMON_FREELIST_SYSTEM;
    set(0);
}

void System::set(int _actor_id)
{
    Electron::set(ACTOR_SYSTEM, _actor_id);
    int_vars[VERSION_INT] = COMM_VERSION_INT;
    int_vars[NUM_PLAYERS] = 0;
    type_name = "SYSTEM";

    for(int i=0;i<STRINGVARS_LAST;i++)
        string_vars[i] = NULL;

    set_string_var(VERSION_STRING, COMM_VERSION_STRING);
    
}

void System::clear()
{
    // possible real clear actions here, *above* the elctron clear

    for(int i=0;i<STRINGVARS_LAST;i++)
    {
        if (string_vars[i])
            delete string_vars[i];
    }
    Electron::clear();
}


void System::set_int_var(int var_id, int val)
{
    int_vars[var_id] = val;
}

void System::set_vector_var(int var_id, Vector v)
{
    vector_vars[var_id] = v;
}

void System::set_string_var(int var_id, char const *string)
{
    if (string_vars[var_id])
        delete string_vars[var_id];
        
    string_vars[var_id] = sstrdup(string);
}

char const *System::get_string_var(int var_id) const
{
    return string_vars[var_id];
}


System *sys;
