/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     simple_room.cc
 *
 *     class implementation of a simple room
 */


#include "simple_room.h"
#include "common/atom.h"

Simple_room::Simple_room()
{
    set(-1);
}

void Simple_room::set(int _actor_id)
{
    Room::set(ACTOR_SIMPLE_ROOM, _actor_id);
    type_name = "simple room";
    freelist_index= COMMON_FREELIST_SIMPLE_ROOM;
}

int Simple_room::can_be_entered(Electron const *other) const
{
    if (other->is_group(GROUP_ROOM))
	return 0;
    
    return 1;
}
