/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          safe_room.cc
 */


#include "safe_room.h"

Safe_room::Safe_room()
{
    set(-1);
}

void Safe_room::set(int _actor_id)
{
    Room::set(ACTOR_SAFE_ROOM, _actor_id);
    type_name = "safe room";
    freelist_index = COMMON_FREELIST_SAFE_ROOM;
}

void Safe_room::clear()
{
    Room::clear();
}

int Safe_room::can_be_entered(Electron const *other) const
{
    if (other->is_group(GROUP_ROOM))
    {
//	warning("safe_room: %s may not enter", other->type_name);
	return 0;
    }

//    warning("safe_room: %s may enter", other->type_name);
    return 1;
}

// macro functions for write_vars and write_hmd
VARS_FUNCTION(Safe_room)
