/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       repairv.h
 *
 *       class definition of a Repair_vehicle
 *       Repair_vehicle is to be used as a base class. Derive
 *       a class (such as Doctor_vehicle) so it has it's own picture.
 *       Derived classes should contain the type of Pad this repair
 *       vehicle should drop. Furthermore they need to decide when to
 *       set up shop and when to pack and continue.
 */


#ifndef _REPAIR_VEHICLE_H_
#define _REPAIR_VEHICLE_H_

#include "vehicle.h"

class Pad;

class Repair_vehicle : public Vehicle
{
public:
    friend class Rvfunc;    // Rvfunc cannot be derived from Repair_vehicle,
                            // so give it access to private members
    enum
    {
	NOTHING = 0,
	MOVING,
	STANDING,
	STATE_LAST
    } states;

    Repair_vehicle(int _actor_id = 0, int _actor_type = 0);
    
    void set(int _actor_type = 0, int _actor_id = 0);
    void clear();

    int can_be_entered(Electron const *other) const;

    void map_finish();            // add inventory to pads list
    
    void add_pad(Pad *p);
    void del_pad(Pad *p);
    int has_pad();                // does the repair vehicle have pads?
    int is_on_pad(Electron *e);   // is this electron on one of our pads?

    // these functions are implemented in class Rvfunc
    // Rvfunc is no longer derived from Repair_vehicle so don't
    // put them in the interface
//    virtual void pulse();         // event fired
//    virtual void unfold();        // drop pads and set up shop
//    virtual void fold();          // collect pads and start moving
//    virtual void move();          // move a step towards the target

protected:
    Atom *target;                 // where are we going?
    List pads;
    int state;                    // what are we doing
    int timer;                    // how long till we start moving
    int stand_time;               // duration of a stop
};

#endif
