/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       repairv.cc
 *
 *       class implementation of a Repair_vehicle
 */

#include "common/atom.h"
#include "repairv.h"
#include "pad.h"

Repair_vehicle::Repair_vehicle(int _actor_type, int _actor_id)
{
    set(_actor_type, _actor_id);
}
    
void Repair_vehicle::set(int _actor_type, int _actor_id)
{
    Vehicle::set(_actor_type, _actor_id);

    // empty the list of pads
    pads.clear();

    state = NOTHING;
    timer = 0;
    stand_time = 40;         // time_unit = pulse
                             // one pulse = 1 second
}

void Repair_vehicle::clear()
{
    Pad *p;
    
    Vehicle::clear();

    // cleanup the pads
    // the actual removal of the pads has to happen in
    // the die() function of the derived repair vehicle
    pads.reset();
    while ((p = dynamic_cast<Pad *>(pads.get())))
    {
	// clear repair_vehicle pointer
	p->set_repair_vehicle(0);

	pads.next();
    }
    pads.clear();
}

int Repair_vehicle::can_be_entered(Electron const *other) const
{
    return (other->is_group(GROUP_PAD)
	    ||
	    other->actor_type == ACTOR_PLAYER);
}

void Repair_vehicle::add_pad(Pad *p)
{
    pads.ifnotfoundpush(p);

    // make sure the reverse coupling is also done!
    p->set_repair_vehicle(this);
}

void Repair_vehicle::del_pad(Pad *p)
{
    pads.pop(p);

    // undo the reverse coupling
    p->set_repair_vehicle(0);
}

// does the repair vehicle have pads?
int Repair_vehicle::has_pad()
{
    if (keys.get_head())
	return 1;
    else
	return 0;
}

// is this electron on one of our pads?
int Repair_vehicle::is_on_pad(Electron *e)
{
    ASSERT(e->get_atom());
    
    Pad *p;
    List *l = e->get_atom()->get(LIST_PAD);

    for (l->reset(); (p = dynamic_cast<Pad *>(l->get())); l->next())
    {
	if (p->get_repair_vehicle() == this)
	    return 1;
    }

    return 0;
}

// called just after object creation:
// put all the pads in our inventory in the pads list
void Repair_vehicle::map_finish()
{
    List *l = inv();
    Electron *e;
    
    if (!l)
	return;

    for (l->reset(); (e = (Electron *)l->get()); l->next())
    {
	if (e->is_group(GROUP_PAD))
	    add_pad(dynamic_cast<Pad *>(e));
    }
}
