/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          repair_pad.cc
 */


#include "repair_pad.h"

Repair_pad::Repair_pad()
{
    set(-1);
}

void Repair_pad::set(int _actor_id)
{
    Pad::set(ACTOR_REPAIR_PAD, _actor_id);
    type_name = "repair pad";
    freelist_index = COMMON_FREELIST_REPAIR_PAD;
    int_vars[RELOADING] = 0;
}

void Repair_pad::clear()
{
    Pad::clear();
}

void Repair_pad::set_reloading(int yesno)
{
    set_int_var(RELOADING, yesno);
}

int Repair_pad::get_reloading()
{
    return int_vars[RELOADING];
}

// macro functions for write_vars and write_hmd
VARS_FUNCTION(Repair_pad)
