/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     player.h
 *
 *     class definition of a player
 */

#ifndef _PLAYER_H_
#define _PLAYER_H_

#include "common/electron.h"
#include "common/atom.h"
#include "common/utils.h"
#include "common/packet.h"
#include "common/actors/weapon.h"
#include "common/actors/vehicle.h"

class Player : public Electron
{
public:
    enum _string_vars
    {
	NAME = 0,
	STRINGVARS_LAST
    };

    enum _int_vars
    {
	HMD_ENUM,
	SCORE,
	DEATHS,
	KILLS,
	INTVARS_LAST
    };
    
    enum _vector_vars
    {
	VECTORVARS_LAST = 0
    };
    
    Player();
    ~Player();

    // player has HMD
    HMD_PROTO;
    WRITE_HMD_PROTO;
    // player has write_vars
    VARS_PROTO;
    
    Vehicle *get_vehicle() const;
    
    // return the first weapon in inventory
    // change this to return the pointer directly if player ever gets
    // a Weapon * member
    Weapon *get_weapon() const;
    
    void set(int actor_id = 0);   // public constructor /destructor
    void clear();

    void reset(); // call when a player dies
                  // this resets hp etc, but not kill scores and name
    
    int can_be_entered(Electron const *other) const;

    int int_vars[INTVARS_LAST];
    Vector vector_vars[VECTORVARS_LAST];
    
protected:
    char *string_vars[STRINGVARS_LAST];
};




#endif
