/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     player.cc
 *
 *     class implementation of the player
 */

#include "player.h"
#include "lightcycle.h"

Player::Player()
{
    set(-1);
}

void Player::set(int _actor_id = 0)
{
    Electron::set(ACTOR_PLAYER, _actor_id);
    freelist_index = COMMON_FREELIST_PLAYER;

    set_hmd(1000,1000,50);   // player takes 100% damage
    int_vars[KILLS] = 0;
    int_vars[DEATHS] = 0;
    
    for (int i = 0; i < STRINGVARS_LAST; i++)
    {
        string_vars[i] = 0;
    }
    type_name = "player";
}

// call this to reset a killed player (hp etc, but not kill score)
void Player::reset()
{
    set_hmd(1000,1000,50);
}

void Player::clear()
{
    for (int i = 0; i < STRINGVARS_LAST; i++)
    {
        if (string_vars[i])
           delete string_vars[i];
        string_vars[i] = 0;
    }
    
    Electron::clear();
}

Player::~Player()
{
    clear();
}

int Player::can_be_entered(Electron const *other) const
{
    if (other->is_group(GROUP_WEAPON))
	return 1;

    if (other->is_group(GROUP_BULLET))
	return 1;

    if (other->actor_type == ACTOR_LIGHTCYCLE
	&&
	other->get_int_var(Lightcycle::BROKEN))
    {
	return 1;
    }

    if (other->actor_type == ACTOR_DOORKEY)
	return 1;
    
    return 0;
}

// find the first weapon in the inventory
Weapon *Player::get_weapon() const
{
    Electron *tmp;
    Weapon *w;

    // check if the player has an inventory
    if (!inventory)
	return 0;
    
    // check if the player has a weapon to fire
    // the player has to carry the weapon in their inventory
    for (inventory->reset();
	 (tmp = (Electron *)inventory->get());
	 inventory->next())
    {
	if (tmp->is_group(GROUP_WEAPON))
	{
	    w = (Weapon *)tmp;
	    return w;
	}
    }

    return 0;
}

// find our vehicle (if we have one)
Vehicle *Player::get_vehicle() const
{
    if (!parent)
	return 0;

    if (parent->is_group(GROUP_VEHICLE))
    {
	return (Vehicle *)parent;
    }

    return 0;
}

// save some typing
WRITE_HMD_FUNCTION( Player )
VARS_FUNCTION( Player )
