/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *           pad.h
 *
 *           class definition of a Pad
 *           Pad is a baseclass to derive other Pads from.
 */

#ifndef _PAD_H_
#define _PAD_H_

#include "common/electron.h"

class Repair_vehicle;
class Pad_event;

class Pad : public Electron
{
public:
    Pad(int _actor_type = 0, int _actor_id = 0);

    void set(int _actor_type = 0, int _actor_id = 0);
    void clear();

    int is_group(int group_id) const;

    virtual void set_reloading(int yesno) = 0;
    virtual int get_reloading() = 0;
    
    Repair_vehicle *get_repair_vehicle();
    void set_repair_vehicle(Repair_vehicle *new_repair_vehicle);

protected:
    Repair_vehicle *rv;
};

#endif
