/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          pad.cc
 *
 *          class implementation of a Pad
 */

#include "pad.h"
#include "repairv.h"

Pad::Pad(int _actor_type, int _actor_id)
{
    set(_actor_type, _actor_id);
}

void Pad::set(int _actor_type = 0, int _actor_id = 0)
{
    Electron::set(_actor_type, _actor_id);

    rv = 0;
}

void Pad::clear()
{
    if (rv)
    {
	rv->del_pad(this);
    }

    rv = 0;
}

Repair_vehicle *Pad::get_repair_vehicle()
{
    return rv;
}

void Pad::set_repair_vehicle(Repair_vehicle *new_repair_vehicle)
{
    rv = new_repair_vehicle;
}

int Pad::is_group(int group_id) const
{
    return (group_id == GROUP_PAD);
}

/*
void Pad::set_reloading(int yesno)
{
    return;
}

int Pad::get_reloading()
{
    return 0;
}
*/
