/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        lightcycle.h
 *
 *        class definition of the Lightcycle
 */

#ifndef _LIGHTCYCLE_H_
#define _LIGHTCYCLE_H_

#include "common/electron.h"
#include "common/utils.h"
#include "vehicle.h"

class Lightcycle : public Vehicle
{
public:
    enum move_results
    {
	CYCLE_CONTINUE = 1,
	CYCLE_STOP,
	CYCLE_CRASH
    };
    enum _int_vars
    {
	HMD_ENUM,
	THROTTLE,
	BROKEN,
	INTVARS_LAST
    };
    enum _string_vars
    {
	STRINGVARS_LAST = 0
    };
    enum _vector_vars
    {
	VECTORVARS_LAST = 0
    };
    
    Lightcycle();
    void set(int _actor_id);
    void clear() { Vehicle::clear(); }

    int can_be_entered(Electron const *other) const;
    
    // lightcycle has HMD
    HMD_PROTO;
    WRITE_HMD_PROTO;
    // make sure this class overloads the write_vars function.
    VARS_PROTO;

    int int_vars[INTVARS_LAST];

    // not used
    Vector vector_vars[VECTORVARS_LAST];

protected:
    char *string_vars[STRINGVARS_LAST];

    // make these functions protected so they can only be called from
    // within the class. outsiders should use set_int_var and get_int_var
    int set_throttle(int _throttle);
    void set_broken(int _broken);
    int get_throttle() const;
    int get_broken() const;
};


#endif

 
