/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         lightcycle.h
 *
 *         class implementation of a Lightcycle
 */

#include "lightcycle.h"

Lightcycle::Lightcycle()
{
    set(-1);
}

void Lightcycle::set(int _actor_id)
{
    Vehicle::set(ACTOR_LIGHTCYCLE, _actor_id);
    type_name = "lightcycle";
    freelist_index = COMMON_FREELIST_LIGHTCYCLE;

    set_broken(0);
    set_throttle(5);
    set_hmd(1000, 1500, 100);
}

int Lightcycle::set_throttle(int _throttle)
{
//    warning("Lightcycle::set_throttle(%d)", _throttle);
    
    if (_throttle >= 0 && _throttle <= 5)
	int_vars[THROTTLE] = _throttle;
    else
	warning("lightcycle::set_throttle: invalid throttle setting: %d",
		_throttle);
    
    return int_vars[THROTTLE];
}

int Lightcycle::get_throttle() const
{
    return int_vars[THROTTLE];
}

void Lightcycle::set_broken(int _broken)
{
    int_vars[BROKEN] = _broken;
}

int Lightcycle::get_broken() const
{
    return int_vars[BROKEN];
}

int Lightcycle::can_be_entered(Electron const *other) const
{
    return (other->actor_type == ACTOR_PLAYER);
}

// this is a bit of a hack to save some typing.
// now we really wish we could have 'virtual static members' in a class
// (
//   we mean a static class member, which you can intialise compile-time
//   like all static class members
//   but which you can then overload for derived classes
//   and the overloaded variant will take preference over
//   the version in the base class
// )
// but alas, we need exactly the same member function
// in each

VARS_FUNCTION(Lightcycle)
WRITE_HMD_FUNCTION(Lightcycle)
