/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       launcher.h
 *
 *       class declaration of a (grenade) Launcher
 */

#ifndef _LAUNCHER_H_
#define _LAUNCHER_H_

#include "common/actors/weapon.h"

class Launcher : public Weapon
{
public:
    enum _int_vars
    {
	HMD_ENUM,
	INTVARS_LAST
    };
    enum _string_vars
    {
	STRINGVARS_LAST = 0
    };
    enum _vector_vars
    {
	VECTORVARS_LAST = 0
    };
    
    Launcher();
    void set(int _actor_id);
    void clear();

    int Launcher::can_be_entered(Electron const *other) const;
    
    // Launcher has HMD  (only used for damage)
    WRITE_HMD_PROTO;
    // make sure this class overloads the write_vars function.
    VARS_PROTO;
    
    int int_vars[INTVARS_LAST];

    // not used
    char *string_vars[STRINGVARS_LAST];
    Vector vector_vars[VECTORVARS_LAST];
};

#endif
