#include "launcher.h"
#include "common/utils.h"

Launcher::Launcher()
{
    set(-1);
}

void Launcher::set(int _actor_id)
{
    Weapon::set(ACTOR_LAUNCHER, _actor_id);
    type_name = "launcher";
    freelist_index = COMMON_FREELIST_LAUNCHER;

    set_hmd(1000, 0, 800);
}

void Launcher::clear()
{
    Weapon::clear();
}

int Launcher::can_be_entered(Electron const *other) const
{
    if (other->actor_type == ACTOR_BLUE_BALL
	||
	other->actor_type == ACTOR_RED_BALL
	||
	other->actor_type == ACTOR_YELLOW_BALL)
    {
	return 1;
    }

    return 0;
}

VARS_FUNCTION(Launcher)
WRITE_HMD_FUNCTION(Launcher)


