/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          laserbeam
 *
 *          class definition of a Laserbeam
 */

#ifndef _LASERBEAM_H_
#define _LASERBEAM_H_

#include "common/actors/bullet.h"
#include "common/freelist.h"

// attention:
// the HMD fields of laserbeam are only used for the damage field
// it is never sent across the network: no write_vars and
// no set_int_var functions.
// if you want to tell the client the damage of a laserbeam, add
// WRITE_VARS to the class, as well as the set_int_vars function

class Laserbeam : public Bullet
{
public:
    enum _int_vars
    {
	HMD_ENUM,
	SOURCE_TYPE,
	SOURCE_ID,
	TARGET_TYPE,
	TARGET_ID,
	INTVARS_LAST
    };
    enum _string_vars
    {
	STRINGVARS_LAST
    };
    enum _vector_vars
    {
	VECTORVARS_LAST
    };
    
    Laserbeam();
    void set(int _actor_id = 0);
    void clear();

    void set_target(Electron *t);
    void set_source(Electron *s);
    
    HMD_PROTO;
    WRITE_HMD_PROTO;
    VARS_PROTO;
    
    int int_vars[INTVARS_LAST];
    Vector vector_vars[VECTORVARS_LAST];

protected:
    char *string_vars[STRINGVARS_LAST];
};


#endif
