/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *      laserbeam.cc
 *
 *      class implementation of a Laserbeam
 */

#include "laserbeam.h"

Laserbeam::Laserbeam()
{
    set(-1);
}

void Laserbeam::set(int _actor_id)
{
    Bullet::set(ACTOR_LASERBEAM, _actor_id);
    type_name = "laserbeam";
    freelist_index = COMMON_FREELIST_LASERBEAM;
    set_hmd(-1,0,100);    // default damage, no real health

    int_vars[SOURCE_TYPE] = -1;
    int_vars[SOURCE_ID] = -1;
    int_vars[TARGET_TYPE] = -1;
    int_vars[TARGET_ID] = -1;
}

void Laserbeam::clear()
{
    Bullet::clear();
}

void Laserbeam::set_target(Electron *target)
{
    int_vars[TARGET_TYPE] = target->actor_type;
    int_vars[TARGET_ID] = target->actor_id;
}

void Laserbeam::set_source(Electron *source)
{
    int_vars[SOURCE_TYPE] = source->actor_type;
    int_vars[SOURCE_ID] = source->actor_id;
}

// macro functions for write_vars and write_hmd
VARS_FUNCTION(Laserbeam)
WRITE_HMD_FUNCTION(Laserbeam)
