/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *       key.cc
 *
 *       implementation of a (vehicle) Key
 */

#include "key.h"
#include "vehicle.h"

Key::Key()
{
    set(-1);
}

void Key::set(int _actor_id)
{
    Weapon::set(ACTOR_KEY, _actor_id);
    type_name = "key";
    freelist_index = COMMON_FREELIST_KEY;
    v = 0;
}

void Key::clear()
{
    Weapon::clear();

    // clear the vehicle
    if (v)
    {
	v->del_key(this);
    }
    v = 0;
}

void Key::set_vehicle(Vehicle *new_v)
{
    v = new_v;
}

Vehicle *Key::get_vehicle()
{
    return v;
}
