/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         hover.cc
 *
 *         class implementation of the Hover
 */

#include "hover.h"
#include "common/defs.h"

Hover::Hover()
{
    set(-1);
}

void Hover::set(int _actor_id)
{
    Vehicle::set(ACTOR_HOVER, _actor_id);
    type_name = "hover";
    freelist_index = COMMON_FREELIST_HOVER;

    set_hmd(1000, 600, 500);
    int_vars[MINES] = 5;
    int_vars[BATTERY] = 500;
}

int Hover::can_be_entered(Electron const *other) const
{
    return Vehicle::can_be_entered(other);
}

// macro functions for write_vars and write_hmd
VARS_FUNCTION(Hover)
WRITE_HMD_FUNCTION(Hover)
