/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *         doorkey.cc
 *
 *         class implementation of a Doorkey
 */


#include "doorkey.h"
#include "door.h"

Doorkey::Doorkey()
{
    set(-1);
}

void Doorkey::set(int _actor_id)
{
    Electron::set(ACTOR_DOORKEY, _actor_id);
    type_name = "doorkey";
    freelist_index = COMMON_FREELIST_DOORKEY;
    d = 0;
}

void Doorkey::clear()
{
    Electron::clear();

    if (d)
    {
	d->del_key(this);
    }
    d = 0;
}

void Doorkey::set_door(Door *new_d)
{
    d = new_d;
}

Door *Doorkey::get_door()
{
    return d;
}

// macro functions for write_vars and write_hmd
VARS_FUNCTION(Doorkey)
