/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *      door.h
 *
 *      class definition of a Door
 */

#ifndef _DOOR_H_
#define _DOOR_H_

#include "room.h"

class Doorkey;
class Player;

class Door : public Room
{
 public:
    enum _int_vars
    {
	STATE = 0,
	INTVARS_LAST
    };
    enum _string_vars
    {
	STRINGVARS_LAST = 0
    };
    enum _vector_vars
    {
	VECTORVARS_LAST = 0
    };
    enum _states
    {
	OPEN = 0,
	OPENING,
	CLOSED,
	CLOSING,
	LOCKED
    };
    
    Door();
    void set(int _actor_id);
    void clear();

    virtual int can_be_entered(Electron const *other) const;    

    int get_state() const;
    void set_state(int _state);

    void add_key(Doorkey *k);
    void del_key(Doorkey *k);
    int has_key();                // does the door have a key (or more)
    int owns_key(Player *pl);     // does the player have one of the keys?
    
    VARS_PROTO;

    int int_vars[INTVARS_LAST];
    // not used
    Vector vector_vars[VECTORVARS_LAST];

protected:
    List keys;
    
    // not used
    char *string_vars[STRINGVARS_LAST];
};

#endif
