/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     door.cc
 *
 *     class implementation of a Door
 */


#include "door.h"
#include "common/atom.h"
#include "doorkey.h"
#include "player.h"

Door::Door()
{
    set(-1);
}

void Door::set(int _actor_id)
{
    Room::set(ACTOR_DOOR, _actor_id);
    type_name = "door";
    freelist_index= COMMON_FREELIST_DOOR;

    keys.clear();
    int_vars[STATE] = OPEN;
}

void Door::clear()
{
    Doorkey *k;
    
    Room::clear();

    // clear the key List
    keys.reset();
    while ((k = (Doorkey *)keys.get()))
    {
	k->set_door(0);
	keys.next();
    }
    keys.clear();

    int_vars[STATE] = OPEN;    
}


int Door::can_be_entered(Electron const *other) const
{
    // everything can enter, except rooms
    if (other->is_group(GROUP_ROOM))
	return 0;

    // you can only enter it in state OPEN
    // closing, closed, locked, opening are all forbidden
    return (int_vars[STATE] == OPEN);
}

int Door::get_state() const
{
    return int_vars[STATE];
}

void Door::set_state(int _state)
{
    ASSERT(_state >= OPEN && _state <= LOCKED);

    int_vars[STATE] = _state;
}

void Door::add_key(Doorkey *k)
{
    keys.ifnotfoundpush(k);
}

void Door::del_key(Doorkey *k)
{
    keys.pop(k);
}

// does the door have a key (or more)
int Door::has_key()                
{
    if (keys.get_head())
	return 1;

    return 0;
}

// does the player have one of the keys?
int Door::owns_key(Player *pl)
{
    Doorkey *k;

    keys.reset();
    while ((k = (Doorkey *)keys.get()))
    {
	// if one of the keys is in the players inventory, return success
	if (pl->inv_contains_recursive(k))
	    return 1;
    	
	keys.next();
    }

    return 0;
}

VARS_FUNCTION(Door)
