/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *        bullet.cc
 *
 *        class implementation of base class Bullet
 */


#include "bullet.h"
#include "common/act_type.h"

Bullet::Bullet(int _actor_type, int _actor_id)
{
    set(_actor_type,_actor_id);
}

void Bullet::set(int _actor_type, int _actor_id)
{
    // just pass it on to electron (this is just a base class for all bullets)
    Electron::set(_actor_type, _actor_id);
}

void Bullet::clear()
{
    Electron::clear();
}

int Bullet::is_group(int group) const
{
    return (group == GROUP_BULLET);
}

int Bullet::explode(Electron *killer)
{
    // overload this one to make it work differently
    warning("Bullet::explode");
    
    return 0;
}

