/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          blue_ball
 *
 *          class definition of a Blue_ball
 */

#ifndef _BLUE_BALL_H_
#define _BLUE_BALL_H_

#include "common/actors/bullet.h"
#include "common/freelist.h"

// attention:
// the HMD fields of blue_ball are only used for the damage field
// it is never sent across the network: no write_vars and
// no set_int_var functions.
// if you want to tell the client the damage of a blue_ball, add
// WRITE_VARS to the class, as well as the set_int_vars function

class Blue_ball : public Bullet
{
public:
    enum _int_vars
    {
	HMD_ENUM,
	INTVARS_LAST
    };

    Blue_ball();
    void set(int _actor_id = 0);
    void clear();

    HMD_PROTO;

    int int_vars[INTVARS_LAST];
};


#endif
