/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *          ambulance.h
 *
 *          ambulance is a Repair_vehicle
 *          that means that the server class Sambulance is derived
 *          from both Ambulance and Rvfunc. To prevent double
 *          derivation of Repair_vehicle, make it virtual public.
 */


#ifndef _AMBULANCE_H_
#define _AMBULANCE_H_


#include "common/actors/repairv.h"

class Ambulance : virtual public Repair_vehicle
{
public:
    enum _int_vars
    {
        HMD_ENUM,
        INTVARS_LAST
    };

    enum _string_vars
    {
        STRINGVARS_LAST = 0
    };

    enum _vector_vars
    {
        VECTORVARS_LAST = 0
    };

    Ambulance();

    // public constructor / destructor
    void set(int actor_id = 0);
    void clear();

    HMD_PROTO;
    WRITE_HMD_PROTO;
    VARS_PROTO;

    int int_vars[INTVARS_LAST];
    Vector vector_vars[VECTORVARS_LAST];

protected:
    char *string_vars[STRINGVARS_LAST];
};

#endif
