/*
 *
 *   ^   |    sssss p   ddddd  fff  ggggg hhhh   iii  j   j    |   ^
 *  /|\  |    s     p   d     f   f   g   h   h i   i jj  j    |  /|\
 *   |   |    sss   p   ddd   f       g   hhhh  i   i j j j    |   |
 *   |  \|/   s     p   d     f   f   g   h   h i   i j  jj   \|/  |
 *   |   v    sssss ppp ddddd  fff    g   h   h  iii  j   j    v   |
 *
 *                           copyright 1999
 *                  Martijn Versteegh & Hein Zelle
 *
 */

/*
 *     act_type.cc
 *
 *     actor type utility functions
 */

#include "electron.h"
#include "packet.h"
#include "freelist.h"
#include "actors/simple_room.h"
#include "actors/player.h"
#include "actors/system.h"
#include "actors/lightcycle.h"
#include "actors/key.h"
#include "actors/cyclewall.h"
#include "actors/tank.h"
#include "actors/grenade.h"
#include "actors/explosion.h"
#include "actors/launcher.h"
#include "actors/blue_ball.h"
#include "actors/yellow_ball.h"
#include "actors/red_ball.h"
#include "actors/hover.h"
#include "actors/laserbeam.h"
#include "actors/mine.h"
#include "actors/door.h"
#include "actors/water.h"
#include "actors/doorkey.h"
#include "actors/ambulance.h"
#include "actors/medical_pad.h"
#include "actors/ammo_pad.h"
#include "actors/repair_pad.h"
#include "actors/fietsenmaker.h"
#include "actors/weaponsmith.h"
#include "actors/vote_room.h"
#include "actors/votemachine.h"
#include "actors/weaponmachine.h"
#include "actors/safe_room.h"
// END_OF_INCLUDES

// translation table for the actor_type <-> list_type conversion
// the list_types enum can be found in common/atom.h
// every actor_type has to be listed in this array!
// order doesn't matter
// the size of this array HAS TO BE equal to ACTOR_LAST
// and *all* members must be initialised!!


actor_entry translate_types[] =
{
    {ACTOR_SYSTEM,       LIST_MISC,    {"ss", "sss", "s"}},
    {ACTOR_SIMPLE_ROOM,  LIST_ROOM,    {"", "", ""}},
    {ACTOR_PLAYER,       LIST_PLAYER,  {"ssssss", "o", ""}},
    {ACTOR_LIGHTCYCLE,   LIST_VEHICLE, {"sssos", "", ""}},
    {ACTOR_KEY,          LIST_KEY,     {"", "", ""}},
    {ACTOR_CYCLEWALL,    LIST_MISC,    {"", "", ""}},
    {ACTOR_TANK,         LIST_VEHICLE, {"sssos", "", ""}},
    {ACTOR_GRENADE,      LIST_BULLET,  {"sss", "", ""}},
    {ACTOR_EXPLOSION,    LIST_BULLET,  {"", "", ""}},
    {ACTOR_LAUNCHER,     LIST_WEAPON,  {"", "", ""}},
    {ACTOR_BLUE_BALL,    LIST_BULLET,  {"sss", "", ""}},
    {ACTOR_YELLOW_BALL,  LIST_BULLET,  {"sss", "", ""}},
    {ACTOR_RED_BALL,     LIST_BULLET,  {"sss", "", ""}},
    {ACTOR_HOVER,        LIST_VEHICLE, {"sssss", "", ""}},
    {ACTOR_LASERBEAM,    LIST_BULLET,  {"sssssss", "", ""}},
    {ACTOR_MINE,         LIST_BULLET,  {"sss", "", ""}},
    {ACTOR_DOOR,         LIST_ROOM,    {"o", "", ""}},
    {ACTOR_WATER,        LIST_ROOM,    {"", "", ""}},
    {ACTOR_DOORKEY,      LIST_KEY,     {"", "", ""}},
    {ACTOR_AMBULANCE,    LIST_VEHICLE, {"sss", "", ""}},
    {ACTOR_MEDICAL_PAD,  LIST_PAD,     {"s", "", ""}},
    {ACTOR_AMMO_PAD,     LIST_PAD,     {"s", "", ""}},
    {ACTOR_REPAIR_PAD,   LIST_PAD,     {"s", "", ""}},
    {ACTOR_FIETSENMAKER, LIST_VEHICLE, {"sss", "", ""}},
    {ACTOR_WEAPONSMITH,  LIST_VEHICLE, {"sss", "", ""}},
    {ACTOR_VOTE_ROOM,    LIST_ROOM,    {"", "", ""}},
    {ACTOR_VOTEMACHINE,  LIST_MISC,    {"", "", ""}},
    {ACTOR_WEAPONMACHINE,LIST_MISC,    {"", "", ""}},
    {ACTOR_SAFE_ROOM,    LIST_ROOM,    {"", "", ""}},
};
// END_OF_TABLE

// this is filled from the above by init_actor_types
int *translate_actor_type = 0;

// a static global of each actor_type
// for example to call Player::can_be_entered as a static function
Electron *global_actor_statics[ACTOR_LAST];

void init_global_actor_statics()
{
    Electron *e = NULL;

    if ((sizeof(translate_types)/ sizeof(actor_entry)) != ACTOR_LAST )
        fatal("translate_types array has the wrong size (%d, %d)",
              (sizeof(translate_types)/ sizeof(actor_entry)) , ACTOR_LAST);

    for (int i = 0; i < ACTOR_LAST; i++)
    {
        switch(i)
        {
            case ACTOR_SYSTEM:
                e = new System;
                break;
            case ACTOR_SIMPLE_ROOM:
                e = new Simple_room;
                break;
            case ACTOR_PLAYER:
                e = new Player;
                break;
            case ACTOR_LIGHTCYCLE:
                e = new Lightcycle;
                break;
            case ACTOR_KEY:
                e = new Key;
                break;
            case ACTOR_CYCLEWALL:
                e = new Cyclewall;
                break;
            case ACTOR_TANK:
                e = new Tank;
                break;
            case ACTOR_GRENADE:
                e = new Grenade;
                break;
            case ACTOR_EXPLOSION:
                e = new Explosion;
                break;
	    case ACTOR_LAUNCHER:
		e = new Launcher;
		break;
	    case ACTOR_BLUE_BALL:
		e = new Blue_ball;
		break;
	    case ACTOR_YELLOW_BALL:
		e = new Yellow_ball;
		break;
	    case ACTOR_RED_BALL:
		e = new Red_ball;
		break;
	    case ACTOR_HOVER:
		e = new Hover;
		break;
	    case ACTOR_LASERBEAM:
		e = new Laserbeam;
		break;
	    case ACTOR_MINE:
		e = new Mine;
		break;
	    case ACTOR_DOOR:
		e = new Door;
		break;
            case ACTOR_WATER:
                e = new Water;
                break;
            case ACTOR_DOORKEY:
                e = new Doorkey;
                break;
            case ACTOR_AMBULANCE:
                e = new Ambulance;
                break;
            case ACTOR_MEDICAL_PAD:
                e = new Medical_pad;
                break;
            case ACTOR_AMMO_PAD:
                e = new Ammo_pad;
                break;
            case ACTOR_REPAIR_PAD:
                e = new Repair_pad;
                break;
            case ACTOR_FIETSENMAKER:
                e = new Fietsenmaker;
                break;
            case ACTOR_WEAPONSMITH:
                e = new Weaponsmith;
                break;
            case ACTOR_VOTE_ROOM:
                e = new Vote_room;
                break;
            case ACTOR_VOTEMACHINE:
                e = new Votemachine;
                break;
            case ACTOR_WEAPONMACHINE:
                e = new Weaponmachine;
                break;
            case ACTOR_SAFE_ROOM:
                e = new Safe_room;
                break;
// END_OF_CASE
            default:
                fatal("Illegal or unknown actor type %d in common/act_type.cc: init_global_actor_statics()", i);
                break;
        }

        e->freelist_index = -1; // mark that this one is made with new, and not with new_actor

        global_actor_statics[i] = e;
    }
}


// this function assumes that the array translate_types has size ACTOR_LAST
// ie that every actor_type is listed exactly once in that array
void init_translate_types()
{
    translate_actor_type = new int[ACTOR_LAST];

    for (int i = 0; i < ACTOR_LAST; i++)
    {
        translate_actor_type[translate_types[i].actor_type] =
	        translate_types[i].list_id;
    }
}

void shutdown_translate_types()
{
    if (translate_actor_type)
    {
        delete [] translate_actor_type;
	translate_actor_type = 0;
    }
}

/*
void init_translate_types()
{
    translate_actor_type = new int[ACTOR_LAST];

    for (int i = 0; i < ACTOR_LAST; i++)
    {
        translate_actor_type[translate_types[i][0]] = translate_types[i][1];
    }
}

void shutdown_translate_types()
{
    if (translate_actor_type)
    {
        delete [] translate_actor_type;
    }
}
*/

// set a variable in an electron from the contents of
// a string/num/vect packet
void set_electron_var(Electron *e, Packet const *p)
{
    switch(p->get_type())
    {
        case TYPE_INFO_NUM:
            e->set_int_var(((Packet_info_num *)p)->var_id,
                           ((Packet_info_num *)p)->var_value);
            break;
        case TYPE_INFO_VECT:
            e->set_vector_var(((Packet_info_vect *)p)->var_id,
                              ((Packet_info_vect *)p)->var_x,
                              ((Packet_info_vect *)p)->var_y);
            break;
        case TYPE_INFO_STRING:
            e->set_string_var(((Packet_info_string *)p)->var_id,
                              ((Packet_info_string *)p)->get_string());
            break;
        default:
            warning("set_electron_var : wrong type of packet (%d) !",
                    p->get_type());
            break;
    }
}


void shutdown_global_actor_statics()
{
    for (int i = 0; i < ACTOR_LAST; i++)
    {
        delete global_actor_statics[i];
    }
}
