#include "common/plug.h"
#include "common/packet.h"
#include "common/utils.h"
//#include <stdio.h>
#include <signal.h>
#include <allegro.h>




int main(int argc, char **argv)
{


    int mystery;
    allegro_init();
    install_timer();
    install_keyboard();
    progname = argv[0];
    
    signal(SIGPIPE, SIG_IGN);

    
    Plug *connection = new Plug();

    if ((mystery = connection->open()))
       fatal("Plug::open returned %d",mystery);
    
    
    Packet *p;


    while (!(key[KEY_ESC]))
    {
        p = read_packet(connection);
        if (p)
        {
            if (p->err)
            {
                fatal("Server closed connection");
            }
            warning("\n\ngot packet");
            print_packet(p);
            warning("end  packet\n\n");
            delete p;
        }

        if (key[KEY_C])
        {
           warning("send command packet 10,100,1,10,20,30,40\n");
           if (Packet_command::write_to(connection, 10, 100, 1, 10,20,30,40) < 0)
           {
                fatal("Server closed connection");
           }
           while(key[KEY_C]);
        }
        
        if (key[KEY_N])
        {
           warning("send info_num packet 10,100,1,10\n");
           if (Packet_info_num::write_to(connection, 10, 100, 1, 10) < 0)
           {
                fatal("Server closed connection");
           }
           while(key[KEY_N]);
        }
        if (key[KEY_S])
        {
           warning("send info_string packet 10,100,1,\"test\"\n");
           if (Packet_info_string::write_to(connection, 10, 100, 1, "test") < 0)
                fatal("Server closed connection");
           while(key[KEY_S]);
        }
        if (key[KEY_Q])
        {
           warning("send info_string packet 10,100,1,\"quit\"\n");
           if (Packet_info_string::write_to(connection, 10, 100, 2, "quit") < 0)
                fatal("Server closed connection");
           
           while(key[KEY_Q]);
        }
        
    }
    delete connection;
    
    return 0;
}

END_OF_MAIN();
